/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness.rendering;

import com.github.atomicblom.shearmadness.api.Capability;
import com.github.atomicblom.shearmadness.api.VariationRegistry;
import com.github.atomicblom.shearmadness.api.capability.IChiseledSheepCapability;
import com.github.atomicblom.shearmadness.api.modelmaker.IModelMaker;
import com.github.atomicblom.shearmadness.configuration.Settings;
import com.github.atomicblom.shearmadness.rendering.ErrorModelMaker;
import com.github.atomicblom.shearmadness.rendering.RenderChiselSheep;
import com.github.atomicblom.shearmadness.utility.Logger;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelQuadruped;
import net.minecraft.client.model.ModelSheep1;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class LayerSheepChiselWool
implements LayerRenderer<EntitySheep> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/entity/sheep/sheep_fur.png");
    private final RenderChiselSheep sheepRenderer;
    private final Cache<Integer, ModelQuadruped> modelCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private final HashSet<Integer> badModels = Sets.newHashSet();
    private final ModelQuadruped defaultBody;
    private final IModelMaker errorModelMaker = new ErrorModelMaker();
    private ModelQuadruped sheepModel;

    public LayerSheepChiselWool(RenderChiselSheep sheepRendererIn) {
        this.sheepRenderer = sheepRendererIn;
        this.sheepModel = this.defaultBody = new ModelSheep1();
    }

    public void doRenderLayer(EntitySheep sheep, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!sheep.func_70892_o() && !sheep.func_82150_aj()) {
            IChiseledSheepCapability capability = (IChiseledSheepCapability)sheep.getCapability(Capability.CHISELED_SHEEP, null);
            if (capability.isChiseled()) {
                int itemIdentifier = capability.getItemIdentifier();
                ItemStack itemStack = capability.getChiselItemStack();
                try {
                    if (Settings.debugModels()) {
                        this.modelCache.invalidate((Object)itemIdentifier);
                    }
                    this.sheepModel = (ModelQuadruped)this.modelCache.get((Object)itemIdentifier, () -> {
                        try {
                            if (this.badModels.contains(itemIdentifier)) {
                                return this.errorModelMaker.createModel(null, (EntityLivingBase)sheep);
                            }
                            IModelMaker variationModelMaker = VariationRegistry.INSTANCE.getVariationModelMaker(itemStack);
                            return variationModelMaker.createModel(itemStack, (EntityLivingBase)sheep);
                        }
                        catch (Exception e) {
                            Logger.log(Level.INFO, e, "Error creating chiseled sheep model, item stack was %s", itemStack);
                            return this.errorModelMaker.createModel(null, (EntityLivingBase)sheep);
                        }
                    });
                    this.sheepRenderer.func_110776_a(TextureMap.field_110575_b);
                    Item item = itemStack.func_77973_b();
                    if (item instanceof ItemBlock) {
                        int colorMultiplier = Minecraft.func_71410_x().func_184125_al().func_186724_a(((ItemBlock)item).field_150939_a.func_176223_P(), (IBlockAccess)sheep.field_70170_p, sheep.func_180425_c(), 0);
                        GlStateManager.func_179124_c((float)((float)(colorMultiplier >> 16 & 0xFF) / 255.0f), (float)((float)(colorMultiplier >> 8 & 0xFF) / 255.0f), (float)((float)(colorMultiplier & 0xFF) / 255.0f));
                    }
                    this.renderModel(sheep, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
                }
                catch (Exception exception) {
                    this.badModels.add(itemIdentifier);
                    this.modelCache.put((Object)itemIdentifier, (Object)this.errorModelMaker.createModel(null, (EntityLivingBase)sheep));
                    Logger.warning("Error rendering chiselled sheep with item %s - %s", itemStack, exception);
                    exception.printStackTrace();
                }
            } else {
                this.sheepModel = this.defaultBody;
                this.sheepRenderer.func_110776_a(TEXTURE);
                float[] afloat = EntitySheep.func_175513_a((EnumDyeColor)sheep.func_175509_cj());
                GlStateManager.func_179124_c((float)afloat[0], (float)afloat[1], (float)afloat[2]);
                this.renderModel(sheep, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
            }
        }
    }

    public void renderModel(EntitySheep sheep, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.sheepModel.func_178686_a(this.sheepRenderer.func_177087_b());
        this.sheepModel.func_78086_a((EntityLivingBase)sheep, limbSwing, limbSwingAmount, partialTicks);
        this.sheepModel.func_78088_a((Entity)sheep, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
    }

    public boolean func_177142_b() {
        return true;
    }
}

