/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness.networking;

import com.github.atomicblom.shearmadness.api.Capability;
import com.github.atomicblom.shearmadness.api.capability.IChiseledSheepCapability;
import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SheepChiseledMessage
implements IMessage {
    private int sheepId;
    private boolean isChiseled;
    private ItemStack itemStack = null;

    public SheepChiseledMessage() {
    }

    public SheepChiseledMessage(Entity sheep) {
        this.sheepId = sheep.func_145782_y();
        IChiseledSheepCapability capability = (IChiseledSheepCapability)sheep.getCapability(Capability.CHISELED_SHEEP, null);
        this.isChiseled = capability.isChiseled();
        this.itemStack = capability.getChiselItemStack();
    }

    public void fromBytes(ByteBuf buf) {
        this.sheepId = buf.readInt();
        this.isChiseled = buf.readBoolean();
        this.itemStack = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.sheepId);
        buf.writeBoolean(this.isChiseled);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.itemStack);
    }

    int getSheepId() {
        return this.sheepId;
    }

    boolean isChiseled() {
        return this.isChiseled;
    }

    ItemStack getChiselItemStack() {
        return this.itemStack;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("sheepId", this.sheepId).add("isChiseled", this.isChiseled).add("itemStack", (Object)this.itemStack).toString();
    }
}

