/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness.capability;

import com.github.atomicblom.shearmadness.api.capability.IChiseledSheepCapability;
import com.github.atomicblom.shearmadness.capability.IWriteExtraData;
import com.github.atomicblom.shearmadness.utility.ItemStackUtils;
import com.google.common.base.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ChiseledSheepCapability
implements IChiseledSheepCapability,
IWriteExtraData {
    @Nullable
    private ItemStack itemStack = null;
    private int itemIdentifier;
    private NBTTagCompound customData = null;

    @Override
    public boolean isChiseled() {
        return this.itemStack != null;
    }

    @Override
    public void chisel(@Nonnull ItemStack itemStack) {
        this.itemStack = itemStack;
        this.itemIdentifier = ItemStackUtils.getHash(itemStack);
    }

    @Override
    public void unChisel() {
        this.itemStack = null;
        this.itemIdentifier = 0;
    }

    @Override
    public ItemStack getChiselItemStack() {
        return this.itemStack;
    }

    @Override
    public int getItemIdentifier() {
        return this.itemIdentifier;
    }

    @Override
    public NBTTagCompound getExtraData() {
        if (this.customData == null) {
            this.customData = new NBTTagCompound();
        }
        return this.customData;
    }

    @Override
    public void setExtraData(NBTTagCompound extraData) {
        this.customData = extraData;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("itemIdentifier", this.itemIdentifier).add("itemStack", (Object)this.itemStack).add("isChiseled", this.isChiseled()).toString();
    }
}

