/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness.api.rendering;

import javax.annotation.Nullable;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Matrix3f;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

@SideOnly(value=Side.CLIENT)
class VertexConsumer
implements IVertexConsumer {
    private final VertexFormat vertexFormat;
    private final Matrix4f positionTransform;
    private final Matrix3f textureTransform;
    private final PositionTextureVertex[] vertices = new PositionTextureVertex[4];
    private int currentVertexIndex = -1;
    @Nullable
    private Vec3d currentPosition = null;
    @Nullable
    private Vector3f currentTexture = null;

    VertexConsumer(VertexFormat vertexFormat, Matrix4f positionTransform, Matrix3f textureTransform) {
        this.vertexFormat = vertexFormat;
        this.positionTransform = positionTransform;
        this.textureTransform = textureTransform;
    }

    TexturedQuad getOutputQuad() {
        return new TexturedQuad(this.vertices);
    }

    public VertexFormat getVertexFormat() {
        return this.vertexFormat;
    }

    public void setQuadTint(int tint) {
    }

    public void setQuadOrientation(EnumFacing orientation) {
    }

    public void setApplyDiffuseLighting(boolean diffuse) {
    }

    public void setTexture(TextureAtlasSprite texture) {
    }

    public void put(int element, float ... data) {
        if (element == 0) {
            ++this.currentVertexIndex;
        }
        VertexFormatElement element1 = this.vertexFormat.func_177348_c(element);
        switch (element1.func_177375_c()) {
            case POSITION: {
                if (data.length < 3) {
                    this.currentPosition = null;
                    return;
                }
                Vector4f position = new Vector4f(data[0], data[1], data[2], 1.0f);
                Vector4f transform = Matrix4f.transform((Matrix4f)this.positionTransform, (Vector4f)position, null);
                this.currentPosition = new Vec3d((double)transform.x, (double)transform.y, (double)transform.z);
                break;
            }
            case UV: {
                if (data.length < 2) {
                    this.currentTexture = null;
                    return;
                }
                Vector3f uvs = new Vector3f(data[0], data[1], 1.0f);
                Vector3f transformedTexture = Matrix3f.transform((Matrix3f)this.textureTransform, (Vector3f)uvs, null);
                this.currentTexture = new Vector3f(transformedTexture.x, transformedTexture.y, transformedTexture.z);
                break;
            }
        }
        if (element == this.vertexFormat.func_177345_h() - 1) {
            if (this.currentPosition == null || this.currentTexture == null) {
                String vertexInfo = "";
                for (VertexFormatElement vertexFormatElement : this.vertexFormat.func_177343_g()) {
                    vertexInfo = vertexInfo + String.format("Element %d - %s\n", vertexFormatElement.func_177369_e(), vertexFormatElement.func_177375_c());
                }
                throw new RuntimeException("Unexpected Vertex Format:\n" + vertexInfo);
            }
            this.vertices[this.currentVertexIndex] = new PositionTextureVertex(this.currentPosition, this.currentTexture.x, this.currentTexture.y);
            this.currentPosition = null;
            this.currentTexture = null;
        }
    }
}

