/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness.api.modelmaker;

import com.github.atomicblom.shearmadness.api.rendering.EntityMesh;
import com.github.atomicblom.shearmadness.api.rendering.PartDefinition;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelQuadruped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.ModelSheep1;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Matrix3f;
import org.lwjgl.util.vector.Matrix4f;

@FunctionalInterface
@SideOnly(value=Side.CLIENT)
public interface IModelMaker {
    public ModelQuadruped createModel(ItemStack var1, EntityLivingBase var2);

    default public ModelRenderer getModelRendererForBlockState(PartDefinition partDefinition, IBlockState blockState, IBakedModel model) {
        ModelRenderer renderer = new ModelRenderer((ModelBase)new ModelSheep1(), 0, 0);
        if (partDefinition == null) {
            return renderer;
        }
        renderer.func_78793_a(partDefinition.getRotationPoint().x, partDefinition.getRotationPoint().y, partDefinition.getRotationPoint().z);
        EntityMesh box = new EntityMesh(renderer);
        this.addBlockModelToEntityMesh(box, partDefinition, blockState, model);
        renderer.field_78804_l.add(box);
        return renderer;
    }

    default public ModelRenderer createModelRenderer(PartDefinition partDefinition) {
        ModelRenderer renderer = new ModelRenderer((ModelBase)new ModelSheep1(), 0, 0);
        if (partDefinition == null) {
            return renderer;
        }
        renderer.func_78793_a(partDefinition.getRotationPoint().x, partDefinition.getRotationPoint().y, partDefinition.getRotationPoint().z);
        return renderer;
    }

    default public EntityMesh addBlockModelToEntityMesh(EntityMesh box, PartDefinition partDefinition, IBlockState blockState, IBakedModel model) {
        Matrix4f positionTransform = partDefinition.getPositionTransform();
        Matrix3f textureTransform = partDefinition.getTextureTransform();
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)BlockRenderLayer.SOLID);
        for (EnumFacing value : EnumFacing.field_82609_l) {
            box.addBakedQuads(positionTransform, textureTransform, model.func_188616_a(blockState, value, 0L));
        }
        box.addBakedQuads(positionTransform, textureTransform, model.func_188616_a(blockState, null, 0L));
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)BlockRenderLayer.CUTOUT);
        for (EnumFacing value : EnumFacing.field_82609_l) {
            box.addBakedQuads(positionTransform, textureTransform, model.func_188616_a(blockState, value, 0L));
        }
        box.addBakedQuads(positionTransform, textureTransform, model.func_188616_a(blockState, null, 0L));
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)BlockRenderLayer.CUTOUT_MIPPED);
        for (EnumFacing value : EnumFacing.field_82609_l) {
            box.addBakedQuads(positionTransform, textureTransform, model.func_188616_a(blockState, value, 0L));
        }
        box.addBakedQuads(positionTransform, textureTransform, model.func_188616_a(blockState, null, 0L));
        ForgeHooksClient.setRenderLayer(null);
        return box;
    }

    default public IBakedModel getBakedModelForItem(ItemStack item, EntityLivingBase entity) {
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        IBakedModel itemModel = renderItem.func_175037_a().func_178089_a(item);
        itemModel = itemModel.func_188617_f().handleItemState(itemModel, item, (World)Minecraft.func_71410_x().field_71441_e, entity);
        return itemModel;
    }
}

