/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness.api.behaviour;

import com.github.atomicblom.shearmadness.api.behaviour.BehaviourBase;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PlaceInvisibleBlockBehaviour
extends BehaviourBase<PlaceInvisibleBlockBehaviour> {
    private final World world;
    private final IBlockState blockState;

    public PlaceInvisibleBlockBehaviour(EntitySheep sheep, Supplier<Boolean> configuration, IBlockState blockState) {
        super(sheep, configuration);
        this.world = sheep.field_70170_p;
        this.blockState = blockState;
    }

    @Override
    public void onBehaviourStopped(BlockPos previousPos) {
        this.resetBlock(previousPos);
    }

    @Override
    public void onBehaviourStarted(BlockPos currentPos) {
        this.setBlock(currentPos);
    }

    @Override
    public void onSheepMovedBlock(BlockPos previousLocation, BlockPos newLocation) {
        this.resetBlock(previousLocation);
        this.setBlock(newLocation);
    }

    private void setBlock(BlockPos newLocation) {
        BlockPos pos = newLocation;
        if (!this.getEntity().func_70631_g_()) {
            pos = pos.func_177984_a();
        }
        if (this.world.func_175623_d(pos)) {
            this.world.func_180501_a(pos, this.blockState, 3);
        }
    }

    private void resetBlock(BlockPos previousLocation) {
        IBlockState blockAtSheep;
        BlockPos pos = previousLocation;
        EntitySheep entity = this.getEntity();
        if (!entity.func_70631_g_()) {
            pos = pos.func_177984_a();
        }
        if (this.blockState.equals(blockAtSheep = this.world.func_180495_p(pos))) {
            this.world.func_175698_g(pos);
        }
    }

    @Override
    public boolean isEquivalentTo(PlaceInvisibleBlockBehaviour other) {
        return super.isEquivalentTo(other) && Objects.equals(this.blockState, other.blockState);
    }
}

