/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness.api.behaviour;

import com.github.atomicblom.shearmadness.api.behaviour.BehaviourBase;
import java.util.Random;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class FlightBehaviour
extends BehaviourBase {
    private final Random random;
    private final float floatHeight;
    private final boolean moveForward;
    private float destinationYaw;
    private int framesTillNextTurn;
    private double destinationMotionY;
    private double currentMotionY;
    private BlockPos sheepLocation = BlockPos.field_177992_a;

    public FlightBehaviour(EntitySheep sheep, float floatHeight, boolean moveForward) {
        super(sheep);
        this.floatHeight = floatHeight;
        this.moveForward = moveForward;
        this.random = new Random();
    }

    @Override
    public void onBehaviourStarted(BlockPos currentPos) {
        this.destinationYaw = this.getEntity().field_70177_z;
        this.framesTillNextTurn = 500;
        this.destinationMotionY = 0.1;
        this.currentMotionY = 0.01;
    }

    @Override
    public void onSheepMovedBlock(BlockPos previousLocation, BlockPos newLocation) {
        this.sheepLocation = newLocation;
    }

    @Override
    public void onBehaviourStopped(BlockPos previousPos) {
        this.getEntity().field_70143_R = 0.0f;
    }

    @Override
    public void updateTask() {
        EntitySheep entity = this.getEntity();
        BlockPos height = entity.field_70170_p.func_175645_m(this.sheepLocation);
        double actualHeight = entity.field_70163_u - (double)height.func_177956_o();
        if (this.currentMotionY < this.destinationMotionY) {
            this.currentMotionY *= 1.05;
        }
        if (actualHeight < (double)this.floatHeight) {
            entity.field_70181_x = this.currentMotionY;
        }
        if (entity.field_70181_x > 0.3) {
            entity.field_70181_x = 0.3;
        }
        if (entity.field_70181_x < 0.0) {
            entity.field_70181_x = 0.0;
        }
        entity.func_70637_d(true);
        entity.field_70143_R = 0.0f;
        if (this.moveForward) {
            entity.func_70612_e(0.0f, 0.6f);
            entity.field_70177_z = FlightBehaviour.updateRotation(entity.field_70177_z, this.destinationYaw, 2.0f);
            if (MathHelper.func_76142_g((float)(entity.field_70177_z - this.destinationYaw)) < 2.0f) {
                if (this.framesTillNextTurn <= 0) {
                    this.destinationYaw = this.random.nextFloat() * 360.0f;
                    this.framesTillNextTurn = 200;
                } else {
                    --this.framesTillNextTurn;
                }
            }
        }
    }

    private static float updateRotation(float angle, float targetAngle, float maxIncrease) {
        float degrees = MathHelper.func_76142_g((float)(targetAngle - angle));
        if (degrees > maxIncrease) {
            degrees = maxIncrease;
        }
        if (degrees < -maxIncrease) {
            degrees = -maxIncrease;
        }
        return angle + degrees;
    }
}

