/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness.api;

import com.github.atomicblom.shearmadness.api.IBehaviourRegistry;
import com.github.atomicblom.shearmadness.api.ShearMadnessBehaviour;
import com.github.atomicblom.shearmadness.api.behaviour.BehaviourBase;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.ItemStack;

public class BehaviourRegistry
implements IBehaviourRegistry {
    public static final BehaviourRegistry INSTANCE = new BehaviourRegistry();
    private final List<ShearMadnessBehaviour> behaviours = new LinkedList<ShearMadnessBehaviour>();

    @Override
    public void registerBehaviour(Function<ItemStack, Boolean> handlesVariant, Function<EntitySheep, BehaviourBase> behaviourFactory) {
        this.behaviours.add(new ShearMadnessBehaviour(handlesVariant, behaviourFactory));
    }

    public Iterable<BehaviourBase> getApplicableBehaviours(ItemStack itemStack, EntitySheep entity) {
        Iterator<ShearMadnessBehaviour> baseIterator = this.behaviours.iterator();
        return () -> new BehaviourIterator(itemStack, baseIterator, entity);
    }

    private static class BehaviourIterator
    implements Iterator<BehaviourBase> {
        private final Iterator<ShearMadnessBehaviour> baseIterator;
        private final EntitySheep entity;
        private ShearMadnessBehaviour nextBehaviour = null;
        private final ItemStack itemStack;

        private BehaviourIterator(ItemStack itemStack, Iterator<ShearMadnessBehaviour> baseIterator, EntitySheep entity) {
            this.baseIterator = baseIterator;
            this.entity = entity;
            this.itemStack = itemStack;
        }

        @Override
        public boolean hasNext() {
            do {
                if (!this.baseIterator.hasNext()) {
                    return false;
                }
                this.nextBehaviour = this.baseIterator.next();
            } while (!this.nextBehaviour.canHandleItemStack(this.itemStack));
            return true;
        }

        @Override
        public BehaviourBase next() {
            if (this.nextBehaviour == null) {
                throw new NoSuchElementException("Invalid iteration over behaviours");
            }
            return this.nextBehaviour.createBehaviourBase(this.entity);
        }
    }
}

