/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness;

import com.github.atomicblom.shearmadness.api.capability.IChiseledSheepCapability;
import com.github.atomicblom.shearmadness.api.events.RegisterAdditionalCapabilitiesEvent;
import com.github.atomicblom.shearmadness.api.events.RegisterShearMadnessCommandEvent;
import com.github.atomicblom.shearmadness.capability.ChiseledSheepCapability;
import com.github.atomicblom.shearmadness.capability.ChiseledSheepCapabilityStorage;
import com.github.atomicblom.shearmadness.configuration.ConfigurationHandler;
import com.github.atomicblom.shearmadness.configuration.Settings;
import com.github.atomicblom.shearmadness.networking.CheckSheepChiseledRequestMessage;
import com.github.atomicblom.shearmadness.networking.CheckSheepChiseledRequestMessageHandler;
import com.github.atomicblom.shearmadness.networking.PlayCustomSoundMessage;
import com.github.atomicblom.shearmadness.networking.PlayCustomSoundMessageHandler;
import com.github.atomicblom.shearmadness.networking.SheepChiseledMessage;
import com.github.atomicblom.shearmadness.networking.SheepChiseledMessageHandler;
import com.github.atomicblom.shearmadness.networking.SpawnCustomParticleMessage;
import com.github.atomicblom.shearmadness.networking.SpawnCustomParticleMessageHandler;
import com.github.atomicblom.shearmadness.proxy.Proxies;
import com.github.atomicblom.shearmadness.utility.Logger;
import com.github.atomicblom.shearmadness.utility.ShearMadnessCommand;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="shearmadness", version="1.10.2", guiFactory="com.github.atomicblom.shearmadness.configuration.client.ModGuiFactory", dependencies="required-after:chisel@[MC1.10.2-0.0.7.7,)", acceptedMinecraftVersions="[1.9.4, 1.11)")
public class ShearMadnessMod {
    public static final SimpleNetworkWrapper CHANNEL = NetworkRegistry.INSTANCE.newSimpleChannel("shearmadness");

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigurationHandler.init(event.getSuggestedConfigurationFile());
        if (!Settings.isReleaseBuild()) {
            Logger.info("You are not running a release build of Shear Madness. This message is purely for informational purposes.", new Object[0]);
        }
        CHANNEL.registerMessage(CheckSheepChiseledRequestMessageHandler.class, CheckSheepChiseledRequestMessage.class, 0, Side.SERVER);
        CHANNEL.registerMessage(SheepChiseledMessageHandler.class, SheepChiseledMessage.class, 1, Side.CLIENT);
        CHANNEL.registerMessage(SpawnCustomParticleMessageHandler.class, SpawnCustomParticleMessage.class, 2, Side.CLIENT);
        CHANNEL.registerMessage(PlayCustomSoundMessageHandler.class, PlayCustomSoundMessage.class, 3, Side.CLIENT);
        CapabilityManager.INSTANCE.register(IChiseledSheepCapability.class, ChiseledSheepCapabilityStorage.instance, ChiseledSheepCapability::new);
        MinecraftForge.EVENT_BUS.register((Object)Proxies.forgeEventProxy);
        MinecraftForge.EVENT_BUS.register((Object)Proxies.renderProxy);
        MinecraftForge.EVENT_BUS.post((Event)new RegisterAdditionalCapabilitiesEvent());
        Proxies.blockProxy.registerBlocks();
        Proxies.audioProxy.registerSounds();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Proxies.renderProxy.registerRenderers();
        Proxies.forgeEventProxy.fireRegistryEvent();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        ArrayList childCommands = Lists.newArrayList();
        MinecraftForge.EVENT_BUS.post((Event)new RegisterShearMadnessCommandEvent(childCommands));
        event.registerServerCommand((ICommand)new ShearMadnessCommand(childCommands));
    }
}

