/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness;

import com.github.atomicblom.shearmadness.ShearMadnessMod;
import com.github.atomicblom.shearmadness.api.Capability;
import com.github.atomicblom.shearmadness.api.capability.IChiseledSheepCapability;
import com.github.atomicblom.shearmadness.networking.SheepChiseledMessage;
import com.github.atomicblom.shearmadness.utility.ItemStackUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class Chiseling {
    private Chiseling() {
    }

    public static void chiselSheep(Entity sheep, EntityPlayer entityPlayer, ItemStack activeStack) {
        if (sheep.hasCapability(Capability.CHISELED_SHEEP, null)) {
            IChiseledSheepCapability capability = (IChiseledSheepCapability)sheep.getCapability(Capability.CHISELED_SHEEP, null);
            ItemStack chiselItemStack = capability.getChiselItemStack();
            if (Chiseling.updateCapability(activeStack, capability, entityPlayer.func_184812_l_())) {
                activeStack.func_77972_a(1, (EntityLivingBase)entityPlayer);
                if (!sheep.field_70170_p.field_72995_K) {
                    ShearMadnessMod.CHANNEL.sendToAll((IMessage)new SheepChiseledMessage(sheep));
                    if (chiselItemStack != null) {
                        ItemStackUtils.dropItem(sheep, chiselItemStack);
                    }
                }
            }
        }
    }

    private static boolean updateCapability(ItemStack heldChisel, IChiseledSheepCapability capability, boolean isCreative) {
        boolean changed = false;
        if (Chiseling.hasChiselBlock(heldChisel)) {
            changed = Chiseling.changeChiselBlock(heldChisel, capability, isCreative);
        } else if (capability.isChiseled()) {
            capability.unChisel();
            changed = true;
        }
        return changed;
    }

    private static boolean changeChiselBlock(ItemStack heldChisel, IChiseledSheepCapability capability, boolean isCreative) {
        ItemStack chiselItemStack;
        NBTTagCompound tagCompound = heldChisel.func_77978_p();
        assert (tagCompound != null);
        NBTTagCompound chiselData = tagCompound.func_74775_l("chiseldata");
        NBTTagCompound chiselTarget = chiselData.func_74775_l("target");
        if (!chiselTarget.func_74764_b("id")) {
            return false;
        }
        ItemStack currentChisel = capability.getChiselItemStack();
        if (!Chiseling.checkItemStacksEqual(currentChisel, chiselItemStack = ItemStack.func_77949_a((NBTTagCompound)chiselTarget))) {
            ItemStack copy = chiselItemStack.func_77946_l();
            copy.field_77994_a = 1;
            capability.chisel(copy);
            if (!isCreative) {
                --chiselItemStack.field_77994_a;
                if (chiselItemStack.field_77994_a > 0) {
                    chiselItemStack.func_77955_b(chiselTarget);
                    chiselData.func_74782_a("target", (NBTBase)chiselTarget);
                } else {
                    chiselData.func_82580_o("target");
                }
            }
            return true;
        }
        return false;
    }

    private static boolean hasChiselBlock(ItemStack heldChisel) {
        NBTTagCompound chiseldata;
        NBTTagCompound chiselTarget;
        NBTTagCompound tagCompound = heldChisel.func_77978_p();
        return tagCompound != null && (chiselTarget = (chiseldata = tagCompound.func_74775_l("chiseldata")).func_74775_l("target")).func_74764_b("id");
    }

    private static boolean checkItemStacksEqual(ItemStack currentChisel, ItemStack newChisel) {
        if (currentChisel == null && newChisel == null) {
            return true;
        }
        if (currentChisel == null ^ newChisel == null) {
            return false;
        }
        if (newChisel.func_77973_b() != currentChisel.func_77973_b()) {
            return false;
        }
        if (!ItemStack.func_77970_a((ItemStack)newChisel, (ItemStack)currentChisel)) {
            return false;
        }
        return newChisel.func_77984_f() || newChisel.func_77960_j() == currentChisel.func_77960_j();
    }
}

