/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui;

import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.gui.WidgetLayout;
import java.util.ArrayList;
import java.util.List;

public abstract class Panel
extends Widget {
    public static final int FLAG_ONLY_RENDER_WIDGETS_INSIDE = 1;
    public static final int FLAG_ONLY_INTERACT_WITH_WIDGETS_INSIDE = 2;
    public static final int FLAG_UNICODE_FONT = 4;
    public static final int FLAG_DEFAULTS = 3;
    public final List<Widget> widgets = new ArrayList<Widget>();
    private int scrollX = 0;
    private int scrollY = 0;
    private int offsetX = 0;
    private int offsetY = 0;
    private int flags = 0;

    public Panel(int x, int y, int w, int h) {
        super(x, y, w, h);
    }

    public Panel() {
        this(0, 0, 0, 0);
    }

    public void addFlags(int f) {
        this.flags |= f;
    }

    public boolean hasFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    public abstract void addWidgets();

    public void refreshWidgets() {
        this.widgets.clear();
        this.addWidgets();
        this.updateWidgetPositions();
    }

    public void add(Widget widget) {
        widget.setParentPanel(this);
        this.widgets.add(widget);
        if (widget instanceof Panel) {
            ((Panel)widget).refreshWidgets();
        }
    }

    public void addAll(Widget ... widgets) {
        for (Widget w : widgets) {
            this.add(w);
        }
    }

    public void addAll(Iterable<? extends Widget> list) {
        for (Widget widget : list) {
            this.add(widget);
        }
    }

    public void updateWidgetPositions() {
    }

    public void setScrollX(double scroll, int elementsWidth) {
        if (elementsWidth < this.width) {
            this.setScrollX(0);
        } else {
            this.setScrollX((int)(scroll * (double)(elementsWidth - this.width)));
        }
    }

    public void setScrollY(double scroll, int elementsHeight) {
        if (elementsHeight < this.height) {
            this.setScrollY(0);
        } else {
            this.setScrollY((int)(scroll * (double)(elementsHeight - this.height)));
        }
    }

    protected final int align(WidgetLayout layout) {
        return layout.align(this);
    }

    @Override
    public int getAX() {
        return super.getAX() + this.offsetX;
    }

    @Override
    public int getAY() {
        return super.getAY() + this.offsetY;
    }

    public void setOffset(boolean flag) {
        if (flag) {
            this.offsetX = -this.scrollX;
            this.offsetY = -this.scrollY;
        } else {
            this.offsetY = 0;
            this.offsetX = 0;
        }
    }

    public void setScrollX(int scroll) {
        this.scrollX = scroll;
    }

    public void setScrollY(int scroll) {
        this.scrollY = scroll;
    }

    @Override
    public void renderWidget(GuiBase gui) {
        boolean renderInside = this.hasFlag(1);
        boolean useUnicodeFont = this.hasFlag(4);
        boolean unicode = gui.getFont().func_82883_a();
        gui.getFont().func_78264_a(useUnicodeFont);
        int ax = this.getAX();
        int ay = this.getAY();
        if (renderInside) {
            GuiHelper.pushScissor(gui.getScreen(), ax, ay, this.width, this.height);
        }
        this.renderPanelBackground(gui, ax, ay);
        this.setOffset(true);
        for (int i = 0; i < this.widgets.size(); ++i) {
            Widget widget = this.widgets.get(i);
            if (!widget.shouldRender(gui) || renderInside && !widget.collidesWith(ax, ay, this.width, this.height)) continue;
            this.renderWidget(gui, widget, i, ax + this.offsetX, ay + this.offsetY, this.width, this.height);
        }
        this.setOffset(false);
        if (renderInside) {
            GuiHelper.popScissor();
        }
        gui.getFont().func_78264_a(unicode);
    }

    protected void renderPanelBackground(GuiBase gui, int ax, int ay) {
        this.getIcon(gui).draw(ax, ay, this.width, this.height, Color4I.NONE);
    }

    protected void renderWidget(GuiBase gui, Widget widget, int index, int ax, int ay, int w, int h) {
        widget.renderWidget(gui);
    }

    @Override
    public void addMouseOverText(GuiBase gui, List<String> list) {
        if (this.hasFlag(2) && !gui.isMouseOver(this)) {
            return;
        }
        this.setOffset(true);
        for (Widget w : this.widgets) {
            if (!w.isEnabled(gui) || !gui.isMouseOver(w)) continue;
            w.addMouseOverText(gui, list);
        }
        this.setOffset(false);
    }

    @Override
    public boolean mousePressed(GuiBase gui, IMouseButton button) {
        if (this.hasFlag(2) && !gui.isMouseOver(this)) {
            return false;
        }
        this.setOffset(true);
        for (Widget w : this.widgets) {
            if (!w.isEnabled(gui) || !w.mousePressed(gui, button)) continue;
            this.setOffset(false);
            return true;
        }
        this.setOffset(false);
        return false;
    }

    @Override
    public void mouseReleased(GuiBase gui) {
        this.setOffset(true);
        for (Widget w : this.widgets) {
            if (!w.isEnabled(gui)) continue;
            w.mouseReleased(gui);
        }
        this.setOffset(false);
    }

    @Override
    public boolean keyPressed(GuiBase gui, int key, char keyChar) {
        this.setOffset(true);
        for (Widget w : this.widgets) {
            if (!w.isEnabled(gui) || !w.keyPressed(gui, key, keyChar)) continue;
            this.setOffset(false);
            return true;
        }
        this.setOffset(false);
        return false;
    }
}

