/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.client.teamsgui;

import com.feed_the_beast.ftbl.api.EnumTeamColor;
import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.lib.FinalIDObject;
import com.feed_the_beast.ftbl.lib.util.NetUtils;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PublicTeamData
extends FinalIDObject
implements Comparable<PublicTeamData> {
    public final String displayName;
    public final String description;
    public final EnumTeamColor color;
    public final UUID ownerId;
    public final String ownerName;
    public final boolean isInvited;

    public PublicTeamData(ByteBuf io) {
        super(ByteBufUtils.readUTF8String((ByteBuf)io));
        this.displayName = ByteBufUtils.readUTF8String((ByteBuf)io);
        this.description = ByteBufUtils.readUTF8String((ByteBuf)io);
        this.color = EnumTeamColor.VALUES[io.readUnsignedByte()];
        this.ownerId = NetUtils.readUUID(io);
        this.ownerName = ByteBufUtils.readUTF8String((ByteBuf)io);
        this.isInvited = io.readBoolean();
    }

    public PublicTeamData(IForgeTeam team, boolean c) {
        super(team.func_176610_l());
        this.displayName = team.getTitle();
        this.description = team.getDesc();
        this.color = team.getColor();
        this.ownerId = team.getOwner().getId();
        this.ownerName = team.getOwner().getName();
        this.isInvited = c;
    }

    public void write(ByteBuf io) {
        ByteBufUtils.writeUTF8String((ByteBuf)io, (String)this.func_176610_l());
        ByteBufUtils.writeUTF8String((ByteBuf)io, (String)this.displayName);
        ByteBufUtils.writeUTF8String((ByteBuf)io, (String)this.description);
        io.writeByte(this.color.ordinal());
        NetUtils.writeUUID(io, this.ownerId);
        ByteBufUtils.writeUTF8String((ByteBuf)io, (String)this.ownerName);
        io.writeBoolean(this.isInvited);
    }

    @Override
    public int compareTo(PublicTeamData o) {
        int i = Boolean.compare(o.isInvited, this.isInvited);
        if (i == 0) {
            i = this.displayName.compareToIgnoreCase(o.displayName);
        }
        return i;
    }
}

