/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.script.command.generation;

import java.util.Iterator;
import me.superckl.api.biometweaker.event.BiomeTweakEvent;
import me.superckl.api.biometweaker.script.pack.IBiomePackage;
import me.superckl.api.superscript.command.IScriptCommand;
import me.superckl.biometweaker.common.world.biome.BiomeTweakerBiome;
import me.superckl.biometweaker.config.Config;
import me.superckl.biometweaker.util.LogHelper;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ScriptCommandAddRemoveBiome
implements IScriptCommand {
    private final IBiomePackage pack;
    private final boolean remove;
    private final String type;
    private final int weight;

    public ScriptCommandAddRemoveBiome(IBiomePackage pack) {
        this(pack, true, null, 0);
    }

    public ScriptCommandAddRemoveBiome(IBiomePackage pack, String type, int weight) {
        this(pack, false, type, weight);
    }

    @Override
    public void perform() throws Exception {
        if (this.remove) {
            Iterator<Biome> it = this.pack.getIterator();
            while (it.hasNext()) {
                Biome gen = it.next();
                for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
                    for (BiomeManager.BiomeEntry entry : BiomeManager.getBiomes((BiomeManager.BiomeType)type)) {
                        if (Biome.func_185362_a((Biome)entry.biome) != Biome.func_185362_a((Biome)gen) || MinecraftForge.EVENT_BUS.post((Event)new BiomeTweakEvent.Remove(this, entry.biome, entry))) continue;
                        BiomeManager.removeBiome((BiomeManager.BiomeType)type, (BiomeManager.BiomeEntry)entry);
                        if (!BiomeManager.getBiomes((BiomeManager.BiomeType)type).isEmpty()) continue;
                        LogHelper.warn("Viable generation biomes for type " + type + " is empty! This will cause Vanilla generation to crash! You've been warned!");
                    }
                }
                Config.INSTANCE.onTweak(Biome.func_185362_a((Biome)gen));
            }
        } else {
            for (int i : this.pack.getRawIds()) {
                BiomeTweakerBiome biome = new BiomeTweakerBiome(new Biome.BiomeProperties("BiomeTweaker Biome").func_185398_c(0.125f).func_185400_d(0.05f).func_185410_a(0.8f).func_185395_b(0.4f));
                if (!MinecraftForge.EVENT_BUS.post((Event)new BiomeTweakEvent.Create(this, biome))) {
                    BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.getType((String)this.type), (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)biome, this.weight));
                    Biome.func_185354_a((int)i, (String)("bt_custom_biome_" + i), (Biome)biome);
                }
                Config.INSTANCE.onTweak(i);
            }
        }
    }

    private ScriptCommandAddRemoveBiome(IBiomePackage pack, boolean remove, String type, int weight) {
        this.pack = pack;
        this.remove = remove;
        this.type = type;
        this.weight = weight;
    }
}

