/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.core;

import com.google.common.collect.Sets;
import java.util.Set;
import me.superckl.api.superscript.util.CollectionHelper;
import me.superckl.biometweaker.config.Config;
import me.superckl.biometweaker.core.ModBiomeTweakerCore;
import me.superckl.biometweaker.core.module.IClassTransformerModule;
import me.superckl.biometweaker.core.module.ModuleBiomeGenBase;
import me.superckl.biometweaker.core.module.ModuleBiomeGenBaseSubclass;
import me.superckl.biometweaker.core.module.ModuleBlockOldLeaf;
import net.minecraft.launchwrapper.IClassTransformer;

public class BiomeTweakerASMTransformer
implements IClassTransformer {
    private final Set<IClassTransformerModule> modules = Sets.newIdentityHashSet();

    public BiomeTweakerASMTransformer() {
        this.registerModule(new ModuleBiomeGenBase());
        this.registerModule(new ModuleBlockOldLeaf());
        this.registerModule(new ModuleBiomeGenBaseSubclass());
    }

    public void registerModule(IClassTransformerModule module) {
        this.modules.add(module);
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null || CollectionHelper.find(transformedName, Config.INSTANCE.getAsmBlacklist()) != -1) {
            return basicClass;
        }
        boolean lightASM = Config.INSTANCE.isLightASM();
        for (IClassTransformerModule module : this.modules) {
            if (lightASM && !module.isRequired()) continue;
            for (String clazz : module.getClassesToTransform()) {
                if (!clazz.equals("*") && !clazz.equals(transformedName)) continue;
                try {
                    byte[] newBytes = module.transform(name, transformedName, basicClass);
                    basicClass = newBytes;
                }
                catch (Exception e) {
                    ModBiomeTweakerCore.logger.error("Caught an exception from module " + module.getModuleName());
                    e.printStackTrace();
                }
            }
        }
        return basicClass;
    }
}

