/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import me.superckl.api.superscript.ScriptCommandManager;
import me.superckl.api.superscript.command.IScriptCommand;
import me.superckl.biometweaker.core.ModBiomeTweakerCore;
import org.apache.logging.log4j.Logger;

public class Config {
    public static final Config INSTANCE = new Config();
    private final ScriptCommandManager commandManager = ScriptCommandManager.newInstance("biometweaker");
    private final Set<Integer> tweakedBiomes = new HashSet<Integer>();
    private boolean outputSeperateFiles = true;
    private boolean versionCheck = false;
    private boolean lightASM = false;
    private String[] asmBlacklist = new String[0];
    private boolean removeLateAssignments = false;
    private JsonArray includes = new JsonArray();
    private boolean init;
    private File whereAreWe;

    private Config() {
    }

    public void init(File whereAreWe, JsonObject obj) {
        Logger log = ModBiomeTweakerCore.logger;
        this.whereAreWe = whereAreWe;
        if (this.init) {
            log.warn("Config is already initialized! Tweaks will be applied immediately. Values changed previously will not be restored.");
        }
        this.commandManager.reset();
        if (obj.has("separate files")) {
            this.outputSeperateFiles = obj.get("separate files").getAsBoolean();
        }
        if (obj.has("version check")) {
            this.versionCheck = obj.get("version check").getAsBoolean();
        }
        if (obj.has("enable light asm")) {
            this.lightASM = obj.get("enable light asm").getAsBoolean();
        }
        if (obj.has("asm blacklist")) {
            JsonArray array = obj.get("asm blacklist").getAsJsonArray();
            this.asmBlacklist = new String[array.size()];
            for (int i = 0; i < this.asmBlacklist.length; ++i) {
                this.asmBlacklist[i] = array.get(i).getAsString();
            }
        }
        if (obj.has("remove late block assignments")) {
            this.removeLateAssignments = obj.get("remove late block assignments").getAsBoolean();
        }
        if (obj.has("include")) {
            JsonElement element = obj.get("include");
            if (element.isJsonArray()) {
                JsonArray array;
                this.includes = array = (JsonArray)element;
            } else {
                log.warn("Failed to parse include array! Check your formatting!");
            }
        }
        this.init = true;
        ModBiomeTweakerCore.logger.info("Finished config parsing.");
    }

    public void addCommand(IScriptCommand command) {
        this.commandManager.addCommand(command);
    }

    public void onTweak(int biomeID) {
        this.tweakedBiomes.add(biomeID);
    }

    public ScriptCommandManager getCommandManager() {
        return this.commandManager;
    }

    public Set<Integer> getTweakedBiomes() {
        return this.tweakedBiomes;
    }

    public boolean isOutputSeperateFiles() {
        return this.outputSeperateFiles;
    }

    public boolean isVersionCheck() {
        return this.versionCheck;
    }

    public boolean isLightASM() {
        return this.lightASM;
    }

    public String[] getAsmBlacklist() {
        return this.asmBlacklist;
    }

    public boolean isRemoveLateAssignments() {
        return this.removeLateAssignments;
    }

    public JsonArray getIncludes() {
        return this.includes;
    }

    public boolean isInit() {
        return this.init;
    }

    public File getWhereAreWe() {
        return this.whereAreWe;
    }

    public static class Fields {
        public static final String SEPARATE_FILES = "separate files";
        public static final String VERSION_CHECK = "version check";
        public static final String ENABLE_LIGHT_ASM = "enable light asm";
        public static final String ASM_BLACKLIST = "asm blacklist";
        public static final String REMOVE_LATE_BLOCK_ASSIGN = "remove late block assignments";
        public static final String INCLUDE = "include";
    }
}

