/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.api.biometweaker.event;

import com.google.gson.JsonElement;
import me.superckl.api.biometweaker.util.SpawnListType;
import me.superckl.api.superscript.command.IScriptCommand;
import net.minecraft.block.Block;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class BiomeTweakEvent
extends Event {
    private final IScriptCommand command;
    private final Biome biome;

    public BiomeTweakEvent(IScriptCommand command, Biome biome) {
        this.command = command;
        this.biome = biome;
    }

    public IScriptCommand getCommand() {
        return this.command;
    }

    public Biome getBiome() {
        return this.biome;
    }

    @Cancelable
    public static class RegisterGenBlockReplacement
    extends BiomeTweakEvent {
        private final int weight;
        private final Block toReplace;
        private final Integer toReplaceMeta;
        private final Block replaceWith;
        private final Integer replaceWithMeta;

        public RegisterGenBlockReplacement(IScriptCommand command, int weight, Biome biome, Block toReplace, Integer toReplaceMeta, Block replaceWith, Integer replaceWithMeta) {
            super(command, biome);
            this.weight = weight;
            this.toReplace = toReplace;
            this.toReplaceMeta = toReplaceMeta;
            this.replaceWith = replaceWith;
            this.replaceWithMeta = replaceWithMeta;
        }

        public int getWeight() {
            return this.weight;
        }

        public Block getToReplace() {
            return this.toReplace;
        }

        public Integer getToReplaceMeta() {
            return this.toReplaceMeta;
        }

        public Block getReplaceWith() {
            return this.replaceWith;
        }

        public Integer getReplaceWithMeta() {
            return this.replaceWithMeta;
        }
    }

    @Cancelable
    public static class RemoveFlower
    extends BiomeTweakEvent {
        private final Block block;
        private final int metdata;

        public RemoveFlower(IScriptCommand command, Biome biome, Block block, int meta) {
            super(command, biome);
            this.block = block;
            this.metdata = meta;
        }

        public Block getBlock() {
            return this.block;
        }

        public int getMetdata() {
            return this.metdata;
        }
    }

    @Cancelable
    public static class AddFlower
    extends BiomeTweakEvent {
        private final Block block;
        private final int metdata;
        private final int weight;

        public AddFlower(IScriptCommand command, Biome biome, Block block, int meta, int weight) {
            super(command, biome);
            this.block = block;
            this.metdata = meta;
            this.weight = weight;
        }

        public Block getBlock() {
            return this.block;
        }

        public int getMetdata() {
            return this.metdata;
        }

        public int getWeight() {
            return this.weight;
        }
    }

    @Cancelable
    public static class SetProperty
    extends BiomeTweakEvent {
        private final String property;
        private final JsonElement value;

        public SetProperty(IScriptCommand command, Biome biome, String property, JsonElement value) {
            super(command, biome);
            this.property = property;
            this.value = value;
        }

        public String getProperty() {
            return this.property;
        }

        public JsonElement getValue() {
            return this.value;
        }
    }

    @Cancelable
    public static class AddSpawn
    extends BiomeTweakEvent {
        private final Biome.SpawnListEntry spawnEntry;

        public AddSpawn(IScriptCommand command, Biome biome, Biome.SpawnListEntry spawnEntry) {
            super(command, biome);
            this.spawnEntry = spawnEntry;
        }

        public Biome.SpawnListEntry getSpawnEntry() {
            return this.spawnEntry;
        }
    }

    @Cancelable
    public static class RemoveAllSpawns
    extends BiomeTweakEvent {
        private final SpawnListType type;

        public RemoveAllSpawns(IScriptCommand command, Biome biome, SpawnListType type) {
            super(command, biome);
            this.type = type;
        }

        public SpawnListType getType() {
            return this.type;
        }
    }

    @Cancelable
    public static class RemoveSpawn
    extends BiomeTweakEvent {
        private final SpawnListType type;
        private final Class<?> entityClass;

        public RemoveSpawn(IScriptCommand command, Biome biome, SpawnListType type, Class<?> entityClass) {
            super(command, biome);
            this.type = type;
            this.entityClass = entityClass;
        }

        public SpawnListType getType() {
            return this.type;
        }

        public Class<?> getEntityClass() {
            return this.entityClass;
        }
    }

    @Cancelable
    public static class RemoveAllDictionaryTypes
    extends BiomeTweakEvent {
        public RemoveAllDictionaryTypes(IScriptCommand command, Biome biome) {
            super(command, biome);
        }
    }

    @Cancelable
    public static class RemoveDictionaryType
    extends BiomeTweakEvent {
        private final BiomeDictionary.Type type;

        public RemoveDictionaryType(IScriptCommand command, Biome biome, BiomeDictionary.Type type) {
            super(command, biome);
            this.type = type;
        }

        public BiomeDictionary.Type getType() {
            return this.type;
        }
    }

    @Cancelable
    public static class AddDictionaryType
    extends BiomeTweakEvent {
        private final BiomeDictionary.Type type;

        public AddDictionaryType(IScriptCommand command, Biome biome, BiomeDictionary.Type type) {
            super(command, biome);
            this.type = type;
        }

        public BiomeDictionary.Type getType() {
            return this.type;
        }
    }

    @Cancelable
    public static class RemoveFeature
    extends BiomeTweakEvent {
        private final int biomeID;
        private final String type;

        public RemoveFeature(IScriptCommand command, Biome biome, int biomeID, String type) {
            super(command, biome);
            this.biomeID = biomeID;
            this.type = type;
        }

        public int getBiomeID() {
            return this.biomeID;
        }

        public String getType() {
            return this.type;
        }
    }

    @Cancelable
    public static class RemoveDecoration
    extends BiomeTweakEvent {
        private final int biomeID;
        private final String type;

        public RemoveDecoration(IScriptCommand command, Biome biome, int biomeID, String type) {
            super(command, biome);
            this.biomeID = biomeID;
            this.type = type;
        }

        public int getBiomeID() {
            return this.biomeID;
        }

        public String getType() {
            return this.type;
        }
    }

    @Cancelable
    public static class Remove
    extends BiomeTweakEvent {
        private final BiomeManager.BiomeEntry entry;

        public Remove(IScriptCommand command, Biome biome, BiomeManager.BiomeEntry entry) {
            super(command, biome);
            this.entry = entry;
        }

        public BiomeManager.BiomeEntry getEntry() {
            return this.entry;
        }
    }

    @Cancelable
    public static class AddToGeneration
    extends BiomeTweakEvent {
        private final BiomeManager.BiomeEntry entry;

        public AddToGeneration(IScriptCommand command, Biome biome, BiomeManager.BiomeEntry entry) {
            super(command, biome);
            this.entry = entry;
        }

        public BiomeManager.BiomeEntry getEntry() {
            return this.entry;
        }
    }

    @Cancelable
    public static class Create
    extends BiomeTweakEvent {
        public Create(IScriptCommand command, Biome biome) {
            super(command, biome);
        }
    }
}

