/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.ClientProxy;
import net.ilexiconn.llibrary.client.gui.element.Element;
import net.ilexiconn.llibrary.client.gui.element.IElementGUI;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public abstract class ElementGUI
extends GuiScreen
implements IElementGUI {
    private final Object elementLock = new Object();
    private final List<Element> elements = new ArrayList<Element>();
    private Element currentlyClicking;

    protected abstract void initElements();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addElement(Element element) {
        Object object = this.elementLock;
        synchronized (object) {
            this.elements.add(element);
        }
        element.init();
    }

    @Override
    public void addElements(Collection<Element> elements) {
        elements.forEach(this::addElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeElement(Element element) {
        Object object = this.elementLock;
        synchronized (object) {
            this.elements.remove(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearElements() {
        Object object = this.elementLock;
        synchronized (object) {
            this.elements.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendElementToFront(Element element) {
        if (this.elements.contains(element)) {
            Object object = this.elementLock;
            synchronized (object) {
                this.elements.remove(element);
                this.elements.add(element);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendElementToBack(Element element) {
        if (this.elements.contains(element)) {
            Object object = this.elementLock;
            synchronized (object) {
                this.elements.remove(element);
                this.elements.add(0, element);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isElementOnTop(Element element) {
        float mouseX = this.getPreciseMouseX();
        float mouseY = this.getPreciseMouseY();
        Object object = this.elementLock;
        synchronized (object) {
            List<Element> elements = this.getPostOrderElements();
            for (Element e : elements) {
                if (!e.isVisible() || !(mouseX >= e.getPosX()) || !(mouseY >= e.getPosY()) || !(mouseX < e.getPosX() + (float)e.getWidth()) || !(mouseY < e.getPosY() + (float)e.getHeight())) continue;
                return element == e || element.getParent() != null && element.getParent() == e;
            }
        }
        return false;
    }

    @Override
    public void playClickSound() {
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.field_146297_k.field_71466_p;
    }

    @Override
    public TextureManager getTextureManager() {
        return this.field_146297_k.func_110434_K();
    }

    @Override
    public int getHeight() {
        return this.field_146295_m;
    }

    @Override
    public int getWidth() {
        return this.field_146294_l;
    }

    public void func_73866_w_() {
        this.initElements();
    }

    public void func_73876_c() {
        this.getPostOrderElements().forEach(Element::update);
    }

    public abstract void drawScreen(float var1, float var2, float var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        Gui.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)LLibrary.CONFIG.getTertiaryColor());
        float preciseMouseX = this.getPreciseMouseX();
        float preciseMouseY = this.getPreciseMouseY();
        this.drawScreen(preciseMouseX, preciseMouseY, partialTicks);
        Object object = this.elementLock;
        synchronized (object) {
            this.elements.forEach(element -> this.renderElement((Element)element, preciseMouseX, preciseMouseY, partialTicks));
        }
        int scrollAmount = Mouse.getDWheel();
        if (scrollAmount != 0) {
            for (Element element2 : this.getPostOrderElements()) {
                if (!element2.isVisible() || !element2.isEnabled() || !element2.mouseScrolled(preciseMouseX, preciseMouseY, scrollAmount)) continue;
                return;
            }
        }
    }

    protected void renderElement(Element element, float mouseX, float mouseY, float partialTicks) {
        if (element.isVisible()) {
            element.renderChildren(mouseX, mouseY, partialTicks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        float preciseMouseX = this.getPreciseMouseX();
        float preciseMouseY = this.getPreciseMouseY();
        Object object = this.elementLock;
        synchronized (object) {
            List<Element> elements = this.getPostOrderElements();
            for (Element element : elements) {
                if (!element.isVisible() || !element.isEnabled() || !element.mouseClicked(preciseMouseX, preciseMouseY, mouseButton)) continue;
                this.currentlyClicking = element;
                break;
            }
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        float preciseMouseX = this.getPreciseMouseX();
        float preciseMouseY = this.getPreciseMouseY();
        Object object = this.elementLock;
        synchronized (object) {
            Element element;
            List<Element> elements = this.getPostOrderElements();
            Iterator<Element> iterator = elements.iterator();
            while (!(!iterator.hasNext() || (element = iterator.next()).isVisible() && element.isEnabled() && this.currentlyClicking == element && element.mouseDragged(preciseMouseX, preciseMouseY, clickedMouseButton, timeSinceLastClick))) {
            }
        }
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void func_146286_b(int mouseX, int mouseY, int state) {
        float preciseMouseX = this.getPreciseMouseX();
        float preciseMouseY = this.getPreciseMouseY();
        Object object = this.elementLock;
        synchronized (object) {
            Element element;
            List<Element> elements = this.getPostOrderElements();
            Iterator<Element> iterator = elements.iterator();
            while (!(!iterator.hasNext() || (element = iterator.next()).isVisible() && element.isEnabled() && this.currentlyClicking == element && element.mouseReleased(preciseMouseX, preciseMouseY, state))) {
            }
        }
        super.func_146286_b(mouseX, mouseY, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        Object object = this.elementLock;
        synchronized (object) {
            Element element;
            List<Element> elements = this.getPostOrderElements();
            Iterator<Element> iterator = elements.iterator();
            while (!(!iterator.hasNext() || (element = iterator.next()).isVisible() && element.isEnabled() && element.keyPressed(typedChar, keyCode))) {
            }
        }
        super.func_73869_a(typedChar, keyCode);
    }

    public void func_146281_b() {
        this.clearElements();
    }

    public float getPreciseMouseX() {
        ScaledResolution scaledResolution = new ScaledResolution(ClientProxy.MINECRAFT);
        return (float)Mouse.getX() / (float)scaledResolution.func_78325_e();
    }

    public float getPreciseMouseY() {
        return (float)this.field_146295_m - (float)Mouse.getY() * (float)this.field_146295_m / (float)this.field_146297_k.field_71440_d - 1.0f;
    }

    public Object getElementLock() {
        return this.elementLock;
    }

    public List<Element> getPostOrderElements() {
        ArrayList<Element> result = new ArrayList<Element>();
        this.traverseRecursively(this.elements, result);
        return Lists.reverse(result);
    }

    public List<Element> getPreOrderElements() {
        ArrayList<Element> result = new ArrayList<Element>();
        this.traverseRecursively(this.elements, result);
        return result;
    }

    private void traverseRecursively(List<Element> in, List<Element> out) {
        for (Element element : in) {
            out.add(element);
            this.traverseRecursively(element.getChildren(), out);
        }
    }
}

