/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import com.brandon3055.brandonscore.items.ItemEnergyBase;
import com.brandon3055.brandonscore.lib.EnergyHelper;
import com.brandon3055.brandonscore.utils.InfoHelper;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.api.IInvCharge;
import com.brandon3055.draconicevolution.api.itemupgrade.IUpgradableItem;
import com.brandon3055.draconicevolution.api.itemupgrade.UpgradeHelper;
import com.brandon3055.draconicevolution.entity.EntityPersistentItem;
import com.brandon3055.draconicevolution.items.tools.ToolBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class DraconiumCapacitor
extends ItemEnergyBase
implements IInvCharge,
IUpgradableItem {
    public static final int wyvernTransfer = 8000000;
    public static final int wyvernBaseCap = 64000000;
    public static final int draconicTransfer = 64000000;
    public static final int draconicBaseCap = 256000000;

    public DraconiumCapacitor() {
        this.func_77627_a(true);
        this.addName(0, "wyvern").addName(1, "draconic").addName(2, "creative");
        this.func_77625_d(1);
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        subItems.add(new ItemStack((Item)DEFeatures.draconiumCapacitor, 1, 0));
        subItems.add(ItemNBTHelper.setInteger((ItemStack)new ItemStack((Item)DEFeatures.draconiumCapacitor, 1, 0), (String)"Energy", (int)64000000));
        subItems.add(new ItemStack((Item)DEFeatures.draconiumCapacitor, 1, 1));
        subItems.add(ItemNBTHelper.setInteger((ItemStack)new ItemStack((Item)DEFeatures.draconiumCapacitor, 1, 1), (String)"Energy", (int)256000000));
        subItems.add(ItemNBTHelper.setInteger((ItemStack)new ItemStack((Item)DEFeatures.draconiumCapacitor, 1, 2), (String)"Energy", (int)0x3FFFFFFF));
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityPersistentItem(world, location, itemstack);
    }

    public int getCapacity(ItemStack stack) {
        int tier = stack.func_77952_i();
        int upgrade = UpgradeHelper.getUpgradeLevel(stack, "rfCap");
        switch (tier) {
            case 0: {
                return 64000000 + upgrade * 32000000;
            }
            case 1: {
                return 256000000 + upgrade * 128000000;
            }
            case 2: {
                return Integer.MAX_VALUE;
            }
        }
        return 0;
    }

    public int getMaxReceive(ItemStack stack) {
        int tier = stack.func_77952_i();
        switch (tier) {
            case 0: {
                return 8000000;
            }
            case 1: {
                return 64000000;
            }
            case 2: {
                return Integer.MAX_VALUE;
            }
        }
        return 0;
    }

    public int getMaxExtract(ItemStack stack) {
        int tier = stack.func_77952_i();
        switch (tier) {
            case 0: {
                return 8000000;
            }
            case 1: {
                return 64000000;
            }
            case 2: {
                return Integer.MAX_VALUE;
            }
        }
        return 0;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.func_77952_i() == 2) {
            return maxReceive;
        }
        return super.receiveEnergy(container, maxReceive, simulate);
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.func_77952_i() == 2) {
            return maxExtract;
        }
        return super.extractEnergy(container, maxExtract, simulate);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            short mode = ItemNBTHelper.getShort((ItemStack)stack, (String)"Mode", (short)0);
            int newMode = mode == 3 ? 0 : mode + 1;
            ItemNBTHelper.setShort((ItemStack)stack, (String)"Mode", (short)((short)newMode));
            if (world.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation(InfoHelper.ITC() + I18n.func_135052_a((String)"info.de.capacitorMode.txt", (Object[])new Object[0]) + ": " + InfoHelper.HITC() + I18n.func_135052_a((String)("info.de.capacitorMode" + ItemNBTHelper.getShort((ItemStack)stack, (String)"Mode", (short)0) + ".txt"), (Object[])new Object[0]), new Object[0]));
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public void func_77663_a(ItemStack container, World world, Entity entity, int itemSlot, boolean isSelected) {
        Item item;
        int max;
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        short mode = ItemNBTHelper.getShort((ItemStack)container, (String)"Mode", (short)0);
        if (mode == 1 || mode == 3) {
            for (ItemStack stack : player.func_184193_aE()) {
                max = Math.min(this.getEnergyStored(container), this.getMaxExtract(container));
                if (!EnergyHelper.canReceiveEnergy((ItemStack)stack) || (item = stack.func_77973_b()) instanceof IInvCharge && !((IInvCharge)item).canCharge(stack, player)) continue;
                this.extractEnergy(container, EnergyHelper.insertEnergy((ItemStack)stack, (int)max, (boolean)false), false);
            }
        }
        if (mode == 2 || mode == 3) {
            for (ItemStack stack : player.func_184214_aD()) {
                max = Math.min(this.getEnergyStored(container), this.getMaxExtract(container));
                if (!EnergyHelper.canReceiveEnergy((ItemStack)stack) || (item = stack.func_77973_b()) instanceof IInvCharge && !((IInvCharge)item).canCharge(stack, player)) continue;
                this.extractEnergy(container, EnergyHelper.insertEnergy((ItemStack)stack, (int)max, (boolean)false), false);
            }
        }
    }

    @Override
    public boolean canCharge(ItemStack stack, EntityPlayer player) {
        return false;
    }

    public boolean func_77636_d(ItemStack stack) {
        return ItemNBTHelper.getShort((ItemStack)stack, (String)"Mode", (short)0) > 0;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        if (InfoHelper.holdShiftForDetails(tooltip)) {
            tooltip.add(I18n.func_135052_a((String)"info.de.changwMode.txt", (Object[])new Object[0]));
            tooltip.add(InfoHelper.ITC() + I18n.func_135052_a((String)"info.de.capacitorMode.txt", (Object[])new Object[0]) + ": " + InfoHelper.HITC() + I18n.func_135052_a((String)("info.de.capacitorMode" + ItemNBTHelper.getShort((ItemStack)stack, (String)"Mode", (short)0) + ".txt"), (Object[])new Object[0]));
        }
        ToolBase.holdCTRLForUpgrades(tooltip, stack);
        InfoHelper.addEnergyInfo((ItemStack)stack, tooltip);
        if (stack.func_77952_i() == 2) {
            tooltip.add(InfoHelper.HITC() + I18n.func_135052_a((String)"info.creativeCapacitor.txt", (Object[])new Object[0]) + " " + Utils.formatNumber((long)0x3FFFFFFFL) + " RF/t");
        }
    }

    @Override
    public List<String> getValidUpgrades(ItemStack stack) {
        return new ArrayList<String>(){
            {
                this.add("rfCap");
            }
        };
    }

    @Override
    public int getMaxUpgradeLevel(ItemStack stack, String upgrade) {
        return stack.func_77952_i() == 0 ? 3 : (stack.func_77952_i() == 1 ? 6 : 0);
    }
}

