/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.upgrades;

import java.util.ArrayList;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;
import vswe.stevescarts.containers.ContainerCartAssembler;
import vswe.stevescarts.containers.slots.SlotAssemblerFuel;
import vswe.stevescarts.containers.slots.SlotModule;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.storages.TransferHandler;
import vswe.stevescarts.items.ModItems;
import vswe.stevescarts.modules.data.ModuleData;
import vswe.stevescarts.modules.data.ModuleDataHull;
import vswe.stevescarts.upgrades.BaseEffect;
import vswe.stevescarts.upgrades.Blueprint;
import vswe.stevescarts.upgrades.SimpleInventoryEffect;

public class InputChest
extends SimpleInventoryEffect {
    public InputChest(int inventoryWidth, int inventoryHeight) {
        super(inventoryWidth, inventoryHeight);
    }

    @Override
    public String getName() {
        return Localization.UPGRADES.INPUT_CHEST.translate(String.valueOf(this.getInventorySize()));
    }

    @Override
    public void init(TileEntityUpgrade upgrade) {
        upgrade.getCompound().func_74774_a("TransferCooldown", (byte)0);
    }

    @Override
    public Class<? extends Slot> getSlot(int i) {
        return SlotModule.class;
    }

    @Override
    public void update(TileEntityUpgrade upgrade) {
        if (!upgrade.func_145831_w().field_72995_K && upgrade.getMaster() != null) {
            NBTTagCompound comp = upgrade.getCompound();
            if (comp.func_74771_c("TransferCooldown") != 0) {
                comp.func_74774_a("TransferCooldown", (byte)(comp.func_74771_c("TransferCooldown") - 1));
            } else {
                comp.func_74774_a("TransferCooldown", (byte)20);
                for (int slotId = 0; slotId < upgrade.getUpgrade().getInventorySize(); ++slotId) {
                    ModuleData module;
                    ItemStack itemstack = upgrade.func_70301_a(slotId);
                    if (itemstack == null || (module = ModItems.modules.getModuleData(itemstack)) == null || !this.isValidForBluePrint(upgrade.getMaster(), module) || this.willInvalidate(upgrade.getMaster(), module)) continue;
                    int stackSize = itemstack.field_77994_a;
                    TransferHandler.TransferItem(itemstack, (IInventory)upgrade.getMaster(), (Container)new ContainerCartAssembler(null, upgrade.getMaster()), Slot.class, SlotAssemblerFuel.class, 1);
                    if (itemstack.field_77994_a == 0) {
                        upgrade.func_70299_a(slotId, null);
                    }
                    if (stackSize != itemstack.field_77994_a) break;
                }
            }
        }
    }

    private boolean willInvalidate(TileEntityCartAssembler assembler, ModuleData module) {
        ModuleDataHull hull = assembler.getHullModule();
        if (hull == null) {
            return false;
        }
        ArrayList<ModuleData> modules = assembler.getNonHullModules();
        modules.add(module);
        return ModuleData.checkForErrors(hull, modules) != null;
    }

    private boolean isValidForBluePrint(TileEntityCartAssembler assembler, ModuleData module) {
        for (TileEntityUpgrade tile : assembler.getUpgradeTiles()) {
            for (BaseEffect effect : tile.getUpgrade().getEffects()) {
                if (!(effect instanceof Blueprint)) continue;
                return ((Blueprint)effect).isValidForBluePrint(tile, assembler.getModules(true), module);
            }
        }
        return true;
    }
}

