/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.renders;

import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.models.ModelCartbase;
import vswe.stevescarts.modules.ModuleBase;

public class RendererCart<T extends EntityMinecartModular>
extends Render<T> {
    public RendererCart(RenderManager renderManager) {
        super(renderManager);
        this.field_76989_e = 0.5f;
    }

    protected ResourceLocation getEntityTexture(T entity) {
        return null;
    }

    public void renderCart(EntityMinecartModular cart, double x, double y, double z, float yaw, float partialTickTime) {
        boolean flip;
        if (cart.getModules() != null) {
            for (ModuleBase module : cart.getModules()) {
                if (module.shouldCartRender()) continue;
                return;
            }
        }
        GL11.glPushMatrix();
        double partialPosX = cart.field_70142_S + (cart.field_70165_t - cart.field_70142_S) * (double)partialTickTime;
        double partialPosY = cart.field_70137_T + (cart.field_70163_u - cart.field_70137_T) * (double)partialTickTime;
        double partialPosZ = cart.field_70136_U + (cart.field_70161_v - cart.field_70136_U) * (double)partialTickTime;
        float partialRotPitch = cart.field_70127_C + (cart.field_70125_A - cart.field_70127_C) * partialTickTime;
        Vec3d posFromRail = cart.func_70489_a(partialPosX, partialPosY, partialPosZ);
        if (posFromRail != null && cart.canUseRail()) {
            double predictionLength = 0.3f;
            Vec3d lastPos = cart.func_70495_a(partialPosX, partialPosY, partialPosZ, 0.3f);
            Vec3d nextPos = cart.func_70495_a(partialPosX, partialPosY, partialPosZ, -0.3f);
            if (lastPos == null) {
                lastPos = posFromRail;
            }
            if (nextPos == null) {
                nextPos = posFromRail;
            }
            x += posFromRail.field_72450_a - partialPosX;
            y += (lastPos.field_72448_b + nextPos.field_72448_b) / 2.0 - partialPosY;
            z += posFromRail.field_72449_c - partialPosZ;
            Vec3d difference = nextPos.func_72441_c(-lastPos.field_72450_a, -lastPos.field_72448_b, -lastPos.field_72449_c);
            if (difference.func_72433_c() != 0.0) {
                difference = difference.func_72432_b();
                yaw = (float)(Math.atan2(difference.field_72449_c, difference.field_72450_a) * 180.0 / Math.PI);
                partialRotPitch = (float)(Math.atan(difference.field_72448_b) * 73.0);
            }
        }
        yaw = 180.0f - yaw;
        partialRotPitch *= -1.0f;
        float damageRot = (float)cart.func_70496_j() - partialTickTime;
        float damageTime = cart.func_70491_i() - partialTickTime;
        float damageDir = cart.func_70493_k();
        if (damageTime < 0.0f) {
            damageTime = 0.0f;
        }
        boolean bl = flip = cart.field_70159_w > 0.0 != cart.field_70179_y > 0.0;
        if (cart.cornerFlip) {
            flip = !flip;
        }
        if (cart.getRenderFlippedYaw(yaw + (flip ? 0.0f : 180.0f))) {
            flip = !flip;
        }
        GL11.glTranslatef((float)((float)x), (float)((float)y + 0.375f), (float)((float)z));
        GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)partialRotPitch, (float)0.0f, (float)0.0f, (float)1.0f);
        if (damageRot > 0.0f) {
            damageRot = MathHelper.func_76126_a((float)damageRot) * damageRot * damageTime / 10.0f * damageDir;
            GL11.glRotatef((float)damageRot, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        float f = flip ? 0.0f : 180.0f;
        GL11.glRotatef((float)(flip ? 0.0f : 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.renderModels(cart, (float)(Math.PI * (double)(yaw += f) / 180.0), partialRotPitch, damageRot, 0.0625f, partialTickTime);
        GL11.glPopMatrix();
        this.renderLabel(cart, x, y, z);
    }

    public void renderModels(EntityMinecartModular cart, float yaw, float pitch, float roll, float mult, float partialtime) {
        if (cart.getModules() != null) {
            for (ModuleBase module : cart.getModules()) {
                if (!module.haveModels()) continue;
                for (ModelCartbase model : module.getModels()) {
                    model.render(this, module, yaw, pitch, roll, mult, partialtime);
                }
            }
        }
    }

    public void renderLiquidCuboid(FluidStack liquid, int tankSize, float x, float y, float z, float sizeX, float sizeY, float sizeZ, float mult) {
    }

    protected void renderLabel(EntityMinecartModular cart, double x, double y, double z) {
        float distance;
        ArrayList<String> labels = cart.getLabel();
        if (labels != null && labels.size() > 0 && (distance = cart.func_70032_d(this.field_76990_c.field_78734_h)) <= 64.0f) {
            FontRenderer frend = this.func_76983_a();
            float var12 = 1.6f;
            float var13 = 0.02666667f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.0f), (float)((float)y + 1.0f + (float)(labels.size() - 1) * 0.12f), (float)((float)z));
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)-0.02666667f, (float)-0.02666667f, (float)0.02666667f);
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)2929);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            int boxwidth = 0;
            int boxheight = 0;
            for (String label : labels) {
                boxwidth = Math.max(boxwidth, frend.func_78256_a(label));
                boxheight += frend.field_78288_b;
            }
            int halfW = boxwidth / 2;
            int halfH = boxheight / 2;
            Tessellator tes = Tessellator.func_178181_a();
            VertexBuffer buffer = tes.func_178180_c();
            GL11.glDisable((int)3553);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b((double)(-halfW - 1), (double)(-halfH - 1), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            buffer.func_181662_b((double)(-halfW - 1), (double)(halfH + 1), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            buffer.func_181662_b((double)(halfW + 1), (double)(halfH + 1), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            buffer.func_181662_b((double)(halfW + 1), (double)(-halfH - 1), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            tes.func_78381_a();
            GL11.glEnable((int)3553);
            int yPos = -halfH;
            for (String label2 : labels) {
                frend.func_78276_b(label2, -frend.func_78256_a(label2) / 2, yPos, 0x20FFFFFF);
                yPos += frend.field_78288_b;
            }
            GL11.glEnable((int)2929);
            GL11.glDepthMask((boolean)true);
            yPos = -halfH;
            for (String label2 : labels) {
                frend.func_78276_b(label2, -frend.func_78256_a(label2) / 2, yPos, -1);
                yPos += frend.field_78288_b;
            }
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    public void doRender(EntityMinecartModular par1Entity, double x, double y, double z, float yaw, float partialTickTime) {
        this.renderCart(par1Entity, x, y, z, yaw, partialTickTime);
    }
}

