/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers.tools;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import vswe.stevescarts.api.farms.EnumHarvestResult;
import vswe.stevescarts.api.farms.ITreeModule;
import vswe.stevescarts.api.farms.ITreeProduceModule;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotFuel;
import vswe.stevescarts.containers.slots.SlotSapling;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiMinecart;
import vswe.stevescarts.helpers.BlockPosHelpers;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.modules.ISuppliesModule;
import vswe.stevescarts.modules.ModuleBase;
import vswe.stevescarts.modules.addons.plants.ModulePlantSize;
import vswe.stevescarts.modules.workers.tools.ModuleTool;
import vswe.stevescarts.plugins.APIHelper;

public abstract class ModuleWoodcutter
extends ModuleTool
implements ISuppliesModule {
    private ArrayList<ITreeModule> treeModules;
    private ModulePlantSize plantSize;
    private boolean isPlanting;
    private float cutterAngle = 0.7853982f;
    private DataParameter<Boolean> IS_CUTTING;

    public ModuleWoodcutter(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public byte getWorkPriority() {
        return 80;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, Localization.MODULES.TOOLS.CUTTER.translate(new String[0]), 8, 6, 0x404040);
    }

    @Override
    protected int getInventoryWidth() {
        return super.getInventoryWidth() + 3;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        if (x == 0) {
            return super.getSlot(slotId, x, y);
        }
        return new SlotSapling(this.getCart(), this, slotId, 8 + --x * 18, 28 + y * 18);
    }

    @Override
    public boolean useDurability() {
        return true;
    }

    @Override
    public void init() {
        super.init();
        this.treeModules = new ArrayList();
        for (ModuleBase module : this.getCart().getModules()) {
            if (module instanceof ITreeModule) {
                this.treeModules.add((ITreeModule)((Object)module));
                continue;
            }
            if (!(module instanceof ModulePlantSize)) continue;
            this.plantSize = (ModulePlantSize)module;
        }
        for (ITreeModule treeModule : APIHelper.treeModules) {
            this.treeModules.add(treeModule);
        }
    }

    public abstract int getPercentageDropChance();

    public List<ItemStack> getTierDrop(List<ItemStack> baseItems) {
        ArrayList<ItemStack> nerfedItems = new ArrayList<ItemStack>();
        for (ItemStack item : baseItems) {
            if (item == null) continue;
            this.dropItemByMultiplierChance(nerfedItems, item, this.getPercentageDropChance());
        }
        return nerfedItems;
    }

    private void dropItemByMultiplierChance(List<ItemStack> items, ItemStack item, int percentage) {
        int drop = 0;
        while (percentage > 0) {
            if (this.getCart().field_70146_Z.nextInt(100) < percentage) {
                items.add(item.func_77946_l());
                ++drop;
            }
            percentage -= 100;
        }
    }

    @Override
    public boolean work() {
        int i;
        World world = this.getCart().field_70170_p;
        BlockPos next = this.getNextblock();
        int size = this.getPlantSize();
        this.destroyLeaveBlockOnTrack(world, next);
        this.destroyLeaveBlockOnTrack(world, next.func_177984_a());
        for (i = -size; i <= size; ++i) {
            BlockPos plant;
            if (i == 0) continue;
            int i2 = i;
            if (i2 < 0) {
                i2 = -size - i2 - 1;
            }
            if (!this.plant(size, plant = next.func_177982_a(this.getCart().z() != next.func_177952_p() ? i2 : 0, -1, this.getCart().x() != next.func_177958_n() ? i2 : 0), next.func_177958_n(), next.func_177952_p())) continue;
            this.setCutting(false);
            return true;
        }
        if (!this.isPlanting) {
            for (i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    BlockPos farm = next.func_177982_a(i, -1, j);
                    if (!this.farm(world, farm)) continue;
                    this.setCutting(true);
                    return true;
                }
            }
        }
        this.isPlanting = false;
        this.setCutting(false);
        return false;
    }

    private boolean plant(int size, BlockPos pos, int cx, int cz) {
        if (size == 1 ? (pos.func_177958_n() + pos.func_177952_p()) % 2 == 0 : pos.func_177958_n() == cx && pos.func_177958_n() / size % 2 == 0 || pos.func_177952_p() == cz && pos.func_177952_p() / size % 2 == 0) {
            return false;
        }
        int saplingSlotId = -1;
        ItemStack sapling = null;
        for (int i = 0; i < this.getInventorySize(); ++i) {
            SlotBase slot = this.getSlots().get(i);
            if (!slot.containsValidItem()) continue;
            saplingSlotId = i;
            sapling = this.getStack(i);
            break;
        }
        if (sapling != null) {
            if (this.doPreWork()) {
                for (ITreeModule module : this.treeModules) {
                    if (!module.isSapling(sapling) || !module.plantSapling(this.getCart().field_70170_p, pos, sapling, this.getFakePlayer())) continue;
                    if (sapling.field_77994_a == 0) {
                        this.setStack(saplingSlotId, null);
                    }
                    this.startWorking(25);
                    this.isPlanting = true;
                    return true;
                }
                this.stopWorking();
                this.isPlanting = false;
            } else {
                this.stopWorking();
                this.isPlanting = false;
            }
        }
        return false;
    }

    private boolean farm(World world, BlockPos pos) {
        IBlockState state;
        if (!this.isBroken() && (state = world.func_180495_p(pos = pos.func_177984_a())) != null && this.isWoodHandler(state, pos)) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            ITreeProduceModule produceModule = this.getProduceHandler(state, pos, drops, false);
            if (produceModule != null) {
                for (ItemStack stack : drops) {
                    this.getCart().addItemToChest(stack);
                }
                return true;
            }
            ArrayList<BlockPos> checked = new ArrayList<BlockPos>();
            if (this.removeAt(world, pos, checked)) {
                return true;
            }
            this.stopWorking();
        }
        return false;
    }

    private boolean removeAt(World world, BlockPos here, ArrayList<BlockPos> checked) {
        int basetime;
        ArrayList<ItemStack> stuff;
        checked.add(here);
        IBlockState blockState = world.func_180495_p(here);
        Block block = blockState.func_177230_c();
        if (block == null) {
            return false;
        }
        if (checked.size() < 125 && BlockPosHelpers.getHorizontalDistToCartSquared(here, this.getCart()) < 175.0) {
            for (int type = 0; type < 2; ++type) {
                boolean hitWood = false;
                if (this.isLeavesHandler(blockState, here)) {
                    type = 1;
                } else if (type == 1) {
                    hitWood = true;
                }
                for (int x = -1; x <= 1; ++x) {
                    for (int y = 1; y >= 0; --y) {
                        for (int z = -1; z <= 1; ++z) {
                            BlockPos pos = here.func_177982_a(x, y, z);
                            IBlockState currentState = world.func_180495_p(pos);
                            if (currentState == null || (!hitWood ? !this.isLeavesHandler(currentState, pos) : !this.isWoodHandler(currentState, pos)) || checked.contains(pos)) continue;
                            return this.removeAt(world, pos, checked);
                        }
                    }
                }
            }
        }
        if (this.shouldSilkTouch(blockState, here)) {
            stuff = new ArrayList<ItemStack>();
            ItemStack stack = this.getSilkTouchedItem(blockState);
            if (stack != null) {
                stuff.add(stack);
            }
        } else {
            int fortune = this.enchanter != null ? this.enchanter.getFortuneLevel() : 0;
            stuff = block.getDrops((IBlockAccess)world, here, blockState, fortune);
            ArrayList dropList = new ArrayList();
            BlockEvent.HarvestDropsEvent event = new BlockEvent.HarvestDropsEvent(world, here, blockState, fortune, 1.0f, dropList, (EntityPlayer)this.getFakePlayer(), false);
            MinecraftForge.EVENT_BUS.post((Event)event);
            for (ItemStack drop : dropList) {
                if (drop.func_77973_b() == null || drop.field_77994_a <= 0) continue;
                stuff.add(drop);
            }
            int applerand = 200;
            if (fortune > 0 && (applerand -= 10 << fortune) < 40) {
                applerand = 40;
            }
            if (block == Blocks.field_150362_t && blockState.func_177229_b((IProperty)BlockOldLeaf.field_176239_P) == BlockPlanks.EnumType.OAK && this.getCart().field_70146_Z.nextInt(applerand) == 0) {
                stuff.add(new ItemStack(Items.field_151034_e, 1, 0));
            }
        }
        List<ItemStack> nerfedstuff = this.getTierDrop(stuff);
        boolean first = true;
        for (ItemStack iStack : nerfedstuff) {
            this.getCart().addItemToChest(iStack, Slot.class, SlotFuel.class);
            if (iStack.field_77994_a != 0) {
                if (first) {
                    return false;
                }
                EntityItem entityitem = new EntityItem(world, this.getCart().field_70165_t, this.getCart().field_70163_u, this.getCart().field_70161_v, iStack);
                entityitem.field_70159_w = (float)(here.func_177958_n() - this.getCart().x()) / 10.0f;
                entityitem.field_70181_x = 0.15f;
                entityitem.field_70179_y = (float)(here.func_177952_p() - this.getCart().z()) / 10.0f;
                world.func_72838_d((Entity)entityitem);
            }
            first = false;
        }
        world.func_175698_g(here);
        if (this.isLeavesHandler(blockState, here)) {
            basetime = 2;
            this.damageTool(1);
        } else {
            basetime = 25;
            this.damageTool(5);
        }
        int efficiency = this.enchanter != null ? this.enchanter.getEfficiencyLevel() : 0;
        this.startWorking((int)((double)basetime / Math.pow(1.3f, efficiency)));
        return true;
    }

    @Override
    public void initDw() {
        this.IS_CUTTING = this.createDw(DataSerializers.field_187198_h);
        this.registerDw(this.IS_CUTTING, false);
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    private void setCutting(boolean val) {
        this.updateDw(this.IS_CUTTING, val);
    }

    protected boolean isCutting() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getIsCutting();
        }
        return this.getDw(this.IS_CUTTING);
    }

    public float getCutterAngle() {
        return this.cutterAngle;
    }

    @Override
    public void update() {
        super.update();
        boolean cuttingflag = this.isCutting();
        if (cuttingflag || this.cutterAngle != 0.7853982f) {
            boolean flag = false;
            if (!cuttingflag && this.cutterAngle < 0.7853982f) {
                flag = true;
            }
            this.cutterAngle = (float)((double)(this.cutterAngle + 0.9f) % (Math.PI * 2));
            if (!cuttingflag && this.cutterAngle > 0.7853982f && flag) {
                this.cutterAngle = 0.7853982f;
            }
        }
    }

    @Override
    public boolean haveSupplies() {
        for (int i = 0; i < this.getInventorySize(); ++i) {
            if (!this.getSlots().get(i).containsValidItem()) continue;
            return true;
        }
        return false;
    }

    public boolean isLeavesHandler(IBlockState blockState, BlockPos pos) {
        for (ITreeModule module : this.treeModules) {
            EnumHarvestResult result = module.isLeaves(blockState, pos, this.getCart());
            if (result == EnumHarvestResult.ALLOW) {
                return true;
            }
            if (result != EnumHarvestResult.DISALLOW) continue;
            return false;
        }
        return false;
    }

    public boolean isWoodHandler(IBlockState blockState, BlockPos pos) {
        for (ITreeModule module : this.treeModules) {
            EnumHarvestResult result = module.isWood(blockState, pos, this.getCart());
            if (result == EnumHarvestResult.ALLOW) {
                return true;
            }
            if (result != EnumHarvestResult.DISALLOW) continue;
            return false;
        }
        return false;
    }

    public ITreeProduceModule getProduceHandler(IBlockState blockState, BlockPos pos, List<ItemStack> drops, boolean simulate) {
        for (ITreeModule module : this.treeModules) {
            if (!(module instanceof ITreeProduceModule) || !((ITreeProduceModule)module).harvest(blockState, pos, this.getCart(), drops, simulate, this)) continue;
            return (ITreeProduceModule)module;
        }
        return null;
    }

    public boolean isSaplingHandler(ItemStack sapling) {
        for (ITreeModule module : this.treeModules) {
            if (!module.isSapling(sapling)) continue;
            return true;
        }
        return false;
    }

    private int getPlantSize() {
        if (this.plantSize != null) {
            return this.plantSize.getSize();
        }
        return 1;
    }

    private void destroyLeaveBlockOnTrack(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state != null && this.isLeavesHandler(state, pos)) {
            world.func_175698_g(pos);
        }
    }
}

