/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.storages.tanks;

import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotLiquidInput;
import vswe.stevescarts.containers.slots.SlotLiquidOutput;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiBase;
import vswe.stevescarts.guis.GuiMinecart;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.helpers.storages.ITankHolder;
import vswe.stevescarts.helpers.storages.Tank;
import vswe.stevescarts.modules.storages.ModuleStorage;

public abstract class ModuleTank
extends ModuleStorage
implements IFluidTank,
ITankHolder {
    protected Tank tank;
    private int tick;
    protected int[] tankBounds = new int[]{35, 20, 36, 51};
    private DataParameter<String> FLUID_NAME;
    private DataParameter<Integer> FLUID_AMOUNT;

    public ModuleTank(EntityMinecartModular cart) {
        super(cart);
        this.tank = new Tank(this, this.getTankSize(), 0);
    }

    protected abstract int getTankSize();

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        if (y == 0) {
            return new SlotLiquidInput(this.getCart(), this.tank, -1, slotId, 8 + x * 18, 24 + y * 24);
        }
        return new SlotLiquidOutput(this.getCart(), slotId, 8 + x * 18, 24 + y * 24);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public int getInventoryWidth() {
        return 1;
    }

    @Override
    public int getInventoryHeight() {
        return 2;
    }

    @Override
    public int guiWidth() {
        return 100;
    }

    @Override
    public int guiHeight() {
        return 80;
    }

    public boolean hasVisualTank() {
        return true;
    }

    @Override
    public void update() {
        super.update();
        if (this.tick-- <= 0) {
            this.tick = 5;
            if (!this.getCart().field_70170_p.field_72995_K) {
                this.tank.containerTransfer();
            } else if (!this.isPlaceholder()) {
                if (this.getDw(this.FLUID_NAME).isEmpty()) {
                    this.tank.setFluid(null);
                } else {
                    this.tank.setFluid(new FluidStack(FluidRegistry.getFluid((String)this.getDw(this.FLUID_NAME)), this.getDw(this.FLUID_AMOUNT).intValue()));
                }
            }
        }
    }

    @Override
    public ItemStack getInputContainer(int tankid) {
        return this.getStack(0);
    }

    @Override
    public void clearInputContainer(int tankid) {
        this.setStack(0, null);
    }

    @Override
    public void addToOutputContainer(int tankid, ItemStack item) {
        this.addStack(1, item);
    }

    @Override
    public void onFluidUpdated(int tankid) {
        if (this.getCart().field_70170_p.field_72995_K) {
            return;
        }
        this.updateDw();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiMinecart gui, int x, int y) {
        this.tank.drawFluid(gui, this.tankBounds[0], this.tankBounds[1]);
        ResourceHelper.bindResource("/gui/tank.png");
        this.drawImage(gui, this.tankBounds, 0, 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(gui, this.getTankInfo(), x, y, this.tankBounds);
    }

    protected String getTankInfo() {
        String str = this.tank.getMouseOver();
        if (this.tank.isLocked()) {
            str = str + "\n\n" + TextFormatting.GREEN + Localization.MODULES.TANKS.LOCKED.translate(new String[0]) + "\n" + Localization.MODULES.TANKS.UNLOCK.translate(new String[0]);
        } else if (this.tank.getFluid() != null) {
            str = str + "\n\n" + Localization.MODULES.TANKS.LOCK.translate(new String[0]);
        }
        return str;
    }

    public FluidStack getFluid() {
        return this.tank.getFluid() == null ? null : this.tank.getFluid().copy();
    }

    public int getCapacity() {
        return this.getTankSize();
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill, this.getCart().field_70170_p.field_72995_K);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain, this.getCart().field_70170_p.field_72995_K);
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        if (this.tank.getFluid() != null) {
            NBTTagCompound compound = new NBTTagCompound();
            this.tank.getFluid().writeToNBT(compound);
            tagCompound.func_74782_a(this.generateNBTName("Fluid", id), (NBTBase)compound);
        }
        tagCompound.func_74757_a(this.generateNBTName("Locked", id), this.tank.isLocked());
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        this.tank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound.func_74775_l(this.generateNBTName("Fluid", id))));
        this.tank.setLocked(tagCompound.func_74767_n(this.generateNBTName("Locked", id)));
        this.updateDw();
    }

    @Override
    public int numberOfDataWatchers() {
        return 2;
    }

    protected void updateDw() {
        this.updateDw(this.FLUID_NAME, this.tank.getFluid() == null ? "" : this.tank.getFluid().getFluid().getName());
        this.updateDw(this.FLUID_AMOUNT, this.tank.getFluid() == null ? -1 : this.tank.getFluid().amount);
    }

    @Override
    public void initDw() {
        this.FLUID_NAME = this.createDw(DataSerializers.field_187194_d);
        this.FLUID_AMOUNT = this.createDw(DataSerializers.field_187192_b);
        this.registerDw(this.FLUID_NAME, this.tank.getFluid() == null ? "" : this.tank.getFluid().getFluid().getName());
        this.registerDw(this.FLUID_AMOUNT, this.tank.getFluid() == null ? -1 : this.tank.getFluid().amount);
    }

    public float getFluidRenderHeight() {
        if (this.tank.getFluid() == null) {
            return 0.0f;
        }
        return this.tank.getFluid().amount / this.getTankSize();
    }

    public boolean isCompletelyFilled() {
        return this.getFluid() != null && this.getFluid().amount >= this.getTankSize();
    }

    public boolean isCompletelyEmpty() {
        return this.getFluid() == null || this.getFluid().amount == 0;
    }

    public int getFluidAmount() {
        return this.getFluid() == null ? 0 : this.getFluid().amount;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo(this.getFluid(), this.getCapacity());
    }

    @Override
    protected int numberOfPackets() {
        return 1;
    }

    @Override
    protected void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 0 && (this.getFluid() != null || this.tank.isLocked())) {
            this.tank.setLocked(!this.tank.isLocked());
            if (!this.tank.isLocked() && this.tank.getFluid() != null && this.tank.getFluid().amount <= 0) {
                this.tank.setFluid(null);
                this.updateDw();
            }
        }
    }

    @Override
    public int numberOfGuiData() {
        return 1;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        this.updateGuiData(info, 0, (short)(this.tank.isLocked() ? 1 : 0));
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 0) {
            this.tank.setLocked(data != 0);
        }
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (this.inRect(x, y, this.tankBounds)) {
            byte data = (byte)button;
            if (GuiScreen.func_146272_n()) {
                data = (byte)(data | 2);
            }
            this.sendPacket(0, data);
        }
    }

    @Override
    public void drawImage(int p0, GuiBase p1, int p3, int p4, int p5, int p6, int p7, int p8) {
    }
}

