/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotMilker;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiMinecart;
import vswe.stevescarts.modules.ModuleBase;

public class ModuleMilker
extends ModuleBase {
    int cooldown = 0;
    int milkbuffer = 0;

    public ModuleMilker(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void update() {
        super.update();
        if (this.cooldown <= 0) {
            if (!this.getCart().field_70170_p.field_72995_K && this.getCart().hasFuel()) {
                this.generateMilk();
                this.depositeMilk();
            }
            this.cooldown = 20;
        } else {
            --this.cooldown;
        }
    }

    private void depositeMilk() {
        if (this.milkbuffer > 0) {
            FluidStack ret = FluidContainerRegistry.getFluidForFilledItem((ItemStack)new ItemStack(Items.field_151117_aB));
            if (ret != null) {
                ret.amount = this.milkbuffer;
                this.milkbuffer -= this.getCart().fill(ret, true);
            }
            if (this.milkbuffer == 1000) {
                for (int i = 0; i < this.getInventorySize(); ++i) {
                    ItemStack bucket = this.getStack(i);
                    if (bucket == null || bucket.func_77973_b() != Items.field_151133_ar) continue;
                    ItemStack milk = new ItemStack(Items.field_151117_aB);
                    this.getCart().addItemToChest(milk);
                    if (milk.field_77994_a > 0) continue;
                    this.milkbuffer = 0;
                    ItemStack itemStack = bucket;
                    if (--itemStack.field_77994_a > 0) continue;
                    this.setStack(i, null);
                }
            }
        }
    }

    private void generateMilk() {
        Entity rider;
        if (this.milkbuffer < 1000 && !this.getCart().func_184188_bt().isEmpty() && (rider = (Entity)this.getCart().func_184188_bt().get(0)) != null && rider instanceof EntityCow) {
            this.milkbuffer = Math.min(this.milkbuffer + 75, 1000);
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected int getInventoryWidth() {
        return 2;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotMilker(this.getCart(), slotId, 8 + x * 18, 23 + y * 18);
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        tagCompound.func_74777_a(this.generateNBTName("Milk", id), (short)this.milkbuffer);
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        this.milkbuffer = tagCompound.func_74765_d(this.generateNBTName("Milk", id));
    }
}

