/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.network;

import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.commons.lang3.tuple.Pair;

public abstract class SerializableMessage<REQ extends SerializableMessage>
implements Serializable,
IMessage,
IMessageHandler<REQ, IMessage> {
    private static final long serialVersionUID = 3214832642504369023L;
    private static final Map<Class<?>, Pair<Reader, Writer>> handlers = new HashMap();
    private static final Map<Class<?>, Field[]> fieldCache = new HashMap();

    public abstract IMessage handleMessage(MessageContext var1);

    public final IMessage onMessage(REQ message, MessageContext context) {
        return ((SerializableMessage)message).handleMessage(context);
    }

    public final void fromBytes(ByteBuf buf) {
        try {
            Field[] clFields;
            Class<?> clazz = this.getClass();
            for (Field f : clFields = SerializableMessage.getClassFields(clazz)) {
                Class<?> type = f.getType();
                if (!SerializableMessage.acceptField(f, type)) continue;
                this.readField(f, type, buf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error at reading packet " + this, e);
        }
    }

    public final void toBytes(ByteBuf buf) {
        try {
            Field[] clFields;
            Class<?> clazz = this.getClass();
            for (Field f : clFields = SerializableMessage.getClassFields(clazz)) {
                Class<?> type = f.getType();
                if (!SerializableMessage.acceptField(f, type)) continue;
                this.writeField(f, type, buf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error at writing packet " + this, e);
        }
    }

    private static Field[] getClassFields(Class<?> clazz) {
        if (fieldCache.containsValue(clazz)) {
            return fieldCache.get(clazz);
        }
        Field[] fields = clazz.getFields();
        Arrays.sort(fields, (f1, f2) -> f1.getName().compareTo(f2.getName()));
        fieldCache.put(clazz, fields);
        return fields;
    }

    private final void writeField(Field field, Class<?> type, ByteBuf buf) throws IllegalArgumentException, IllegalAccessException {
        Pair<Reader, Writer> handler = SerializableMessage.getHandler(type);
        ((Writer)handler.getRight()).write(field.get(this), buf);
    }

    private final void readField(Field field, Class<?> type, ByteBuf buf) throws IllegalArgumentException, IllegalAccessException {
        Pair<Reader, Writer> handler = SerializableMessage.getHandler(type);
        field.set(this, ((Reader)handler.getLeft()).read(buf));
    }

    private static Pair<Reader, Writer> getHandler(Class<?> type) {
        Pair<Reader, Writer> pair = handlers.get(type);
        if (pair == null) {
            throw new RuntimeException("No R/W handler for  " + type);
        }
        return pair;
    }

    private static boolean acceptField(Field field, Class<?> type) {
        int mods = field.getModifiers();
        if (Modifier.isFinal(mods) || Modifier.isStatic(mods) || Modifier.isTransient(mods)) {
            return false;
        }
        return handlers.containsKey(type);
    }

    public static <T> void addIOHandler(Class<T> type, Reader<T> reader, Writer<T> writer) {
        handlers.put(type, (Pair<Reader, Writer>)Pair.of(reader, writer));
    }

    private static byte readByte(ByteBuf buf) {
        return buf.readByte();
    }

    private static void writeByte(byte b, ByteBuf buf) {
        buf.writeByte((int)b);
    }

    private static short readShort(ByteBuf buf) {
        return buf.readShort();
    }

    private static void writeShort(short s, ByteBuf buf) {
        buf.writeShort((int)s);
    }

    private static int readInt(ByteBuf buf) {
        return buf.readInt();
    }

    private static void writeInt(int i, ByteBuf buf) {
        buf.writeInt(i);
    }

    private static long readLong(ByteBuf buf) {
        return buf.readLong();
    }

    private static void writeLong(long l, ByteBuf buf) {
        buf.writeLong(l);
    }

    private static float readFloat(ByteBuf buf) {
        return buf.readFloat();
    }

    private static void writeFloat(float f, ByteBuf buf) {
        buf.writeFloat(f);
    }

    private static double readDouble(ByteBuf buf) {
        return buf.readDouble();
    }

    private static void writeDouble(double d, ByteBuf buf) {
        buf.writeDouble(d);
    }

    private static boolean readBoolean(ByteBuf buf) {
        return buf.readBoolean();
    }

    private static void writeBoolean(boolean b, ByteBuf buf) {
        buf.writeBoolean(b);
    }

    private static char readChar(ByteBuf buf) {
        return buf.readChar();
    }

    private static void writeChar(char c, ByteBuf buf) {
        buf.writeChar((int)c);
    }

    private static String readString(ByteBuf buf) {
        return ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    private static void writeString(String s, ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)s);
    }

    private static NBTTagCompound readNBT(ByteBuf buf) {
        return ByteBufUtils.readTag((ByteBuf)buf);
    }

    private static void writeNBT(NBTTagCompound cmp, ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)cmp);
    }

    private static ItemStack readItemStack(ByteBuf buf) {
        return ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    private static void writeItemStack(ItemStack stack, ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack);
    }

    private static BlockPos readBlockPos(ByteBuf buf) {
        return BlockPos.func_177969_a((long)buf.readLong());
    }

    private static void writeBlockPos(BlockPos pos, ByteBuf buf) {
        buf.writeLong(pos.func_177986_g());
    }

    private static ResourceLocation readResourceLocation(ByteBuf buf) {
        return new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
    }

    private static void writeResourceLocation(ResourceLocation location, ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)location.toString());
    }

    static {
        SerializableMessage.addIOHandler(Byte.TYPE, SerializableMessage::readByte, SerializableMessage::writeByte);
        SerializableMessage.addIOHandler(Short.TYPE, SerializableMessage::readShort, SerializableMessage::writeShort);
        SerializableMessage.addIOHandler(Integer.TYPE, SerializableMessage::readInt, SerializableMessage::writeInt);
        SerializableMessage.addIOHandler(Long.TYPE, SerializableMessage::readLong, SerializableMessage::writeLong);
        SerializableMessage.addIOHandler(Float.TYPE, SerializableMessage::readFloat, SerializableMessage::writeFloat);
        SerializableMessage.addIOHandler(Double.TYPE, SerializableMessage::readDouble, SerializableMessage::writeDouble);
        SerializableMessage.addIOHandler(Boolean.TYPE, SerializableMessage::readBoolean, SerializableMessage::writeBoolean);
        SerializableMessage.addIOHandler(Character.TYPE, SerializableMessage::readChar, SerializableMessage::writeChar);
        SerializableMessage.addIOHandler(String.class, SerializableMessage::readString, SerializableMessage::writeString);
        SerializableMessage.addIOHandler(NBTTagCompound.class, SerializableMessage::readNBT, SerializableMessage::writeNBT);
        SerializableMessage.addIOHandler(ItemStack.class, SerializableMessage::readItemStack, SerializableMessage::writeItemStack);
        SerializableMessage.addIOHandler(BlockPos.class, SerializableMessage::readBlockPos, SerializableMessage::writeBlockPos);
        SerializableMessage.addIOHandler(ResourceLocation.class, SerializableMessage::readResourceLocation, SerializableMessage::writeResourceLocation);
    }

    public static interface Reader<T> {
        public T read(ByteBuf var1);
    }

    public static interface Writer<T> {
        public void write(T var1, ByteBuf var2);
    }
}

