/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.ClientHandler;
import codechicken.nei.FingerprintChecker;
import codechicken.nei.ServerHandler;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.asm.NEICorePlugin;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.FMLFileResourcePack;
import net.minecraftforge.fml.client.FMLFolderResourcePack;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionParser;
import net.minecraftforge.fml.common.versioning.VersionRange;

@Mod(modid="nei", acceptedMinecraftVersions="[1.10.2]")
public class NEIModContainer
extends DummyModContainer {
    public static LinkedList<IConfigureNEI> plugins = new LinkedList();
    private String description;

    public NEIModContainer() {
        super(MetadataCollection.from((InputStream)MetadataCollection.class.getResourceAsStream("/neimod.info"), (String)"NotEnoughItems").getMetadataForId("NotEnoughItems", null));
        this.loadMetadata();
    }

    public Set<ArtifactVersion> getRequirements() {
        HashSet<ArtifactVersion> deps = new HashSet<ArtifactVersion>();
        if (!super.getMetadata().version.contains("$")) {
            deps.add(VersionParser.parseVersionReference((String)"CodeChickenLib@[2.5.2,)"));
            deps.add(VersionParser.parseVersionReference((String)"CodeChickenCore@[2.4.0,)"));
            deps.add(VersionParser.parseVersionReference((String)"JEI@[3.13.2,)"));
        }
        return deps;
    }

    public List<ArtifactVersion> getDependencies() {
        return new LinkedList<ArtifactVersion>(this.getRequirements());
    }

    private void loadMetadata() {
        this.description = super.getMetadata().description.replace("Supporters:", TextFormatting.AQUA + "Supporters:");
    }

    public ModMetadata getMetadata() {
        String s_plugins = "";
        if (plugins.size() == 0) {
            s_plugins = s_plugins + TextFormatting.RED + "No installed plugins.";
        } else {
            s_plugins = s_plugins + TextFormatting.GREEN + "Installed plugins: ";
            for (int i = 0; i < plugins.size(); ++i) {
                if (i > 0) {
                    s_plugins = s_plugins + ", ";
                }
                IConfigureNEI plugin = plugins.get(i);
                s_plugins = s_plugins + plugin.getName() + " " + plugin.getVersion();
            }
            s_plugins = s_plugins + ".";
        }
        ModMetadata meta = super.getMetadata();
        meta.description = this.description.replace("<plugins>", s_plugins);
        return meta;
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        FingerprintChecker.runFingerprintChecks();
        if (event.getSide().isClient()) {
            ClientHandler.preInit();
        }
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        if (event.getSide().isClient()) {
            ClientHandler.init();
        }
        ServerHandler.init();
    }

    public VersionRange acceptableMinecraftVersionRange() {
        return VersionParser.parseRange((String)"[1.10.2]");
    }

    public File getSource() {
        return NEICorePlugin.location;
    }

    public Class<?> getCustomResourcePackClass() {
        return this.getSource().isFile() ? FMLFileResourcePack.class : FMLFolderResourcePack.class;
    }

    public Object getMod() {
        return this;
    }
}

