/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.tileentity.machines;

import com.valkyrieofnight.environmentaltech.api.registry.terraformer.ITerraformerSoftware;
import com.valkyrieofnight.environmentaltech.registry.terraformer.TerraformerSoftwareRegistry;
import com.valkyrieofnight.environmentaltech.registry.terraformer.software.SoftwarePlantRemover;
import com.valkyrieofnight.valkyrielib.energy.EnergyReceiver;
import com.valkyrieofnight.valkyrielib.tileentity.VLTileEntity;
import com.valkyrieofnight.valkyrielib.util.BlockOffset;
import com.valkyrieofnight.valkyrielib.util.helpers.MathUtil;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class TileTerraformer
extends VLTileEntity
implements ITickable {
    public static int MAX_BLOCKS_PER_TICK = 10;
    private int tick = 0;
    protected ITerraformerSoftware software;
    protected EnergyReceiver eBuffer = new EnergyReceiver(100000);
    protected boolean requiresRedstone;
    private int radius = 80;
    private boolean updateClients = false;

    public TileTerraformer() {
        this.software = SoftwarePlantRemover.getInstance();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.tick;
            if (this.tick >= 1000) {
                this.tick = 0;
            }
            if (this.tick % 1 == 0 && this.software != null) {
                int eCost = this.software.getMaxIterationsPerTick() * this.software.getEnergyCostPerIteration();
                if (this.eBuffer.getEnergyStored() >= eCost) {
                    this.field_145850_b.func_73046_m().func_145747_a((ITextComponent)new TextComponentString("Testing" + this.tick));
                    for (int i = 0; i < this.software.getMaxIterationsPerTick(); ++i) {
                        BlockOffset bo = MathUtil.getRandomOffsetWithinCircle((Random)new Random(), (int)this.radius);
                        this.software.tick(this.field_145850_b, this.field_174879_c, bo.getXOffset(), bo.getZOffset());
                    }
                    this.eBuffer.extractEnergy(eCost, false);
                }
            }
            if (this.updateClients) {
                this.updateClients = false;
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
    }

    public void setSoftware(int softwareID) {
        this.software = TerraformerSoftwareRegistry.getInstance().getSoftware(softwareID);
    }

    public void setSoftware(String softwareID) {
        this.software = TerraformerSoftwareRegistry.getInstance().getSoftware(softwareID);
    }

    public int getSoftwareID() {
        return TerraformerSoftwareRegistry.getInstance().getSoftwareID(this.software.getID());
    }

    public String getCurrentSoftware() {
        if (this.software != null) {
            return this.software.getID();
        }
        return null;
    }

    public String getCurrentSoftwareLocalized() {
        if (this.software != null) {
            return this.software.getLocalizedName();
        }
        return null;
    }
}

