/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.BlockPhantom;
import de.ellpeck.actuallyadditions.mod.tile.ISharingFluidHandler;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayFluids;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomface;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntityPhantomLiquiface
extends TileEntityPhantomface
implements ISharingFluidHandler {
    public TileEntityPhantomLiquiface() {
        super("liquiface");
        this.type = BlockPhantom.Type.LIQUIFACE;
    }

    @Override
    public boolean isBoundThingInRange() {
        TileEntity tile;
        if (super.isBoundThingInRange() && (tile = this.field_145850_b.func_175625_s(this.boundPosition)) != null && !(tile instanceof TileEntityLaserRelayFluids)) {
            if (tile instanceof net.minecraftforge.fluids.IFluidHandler) {
                return true;
            }
            for (EnumFacing facing : EnumFacing.values()) {
                if (!tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)) continue;
                return true;
            }
        }
        return false;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        TileEntity tile;
        if (this.isBoundThingInRange() && (tile = this.field_145850_b.func_175625_s(this.boundPosition)) != null) {
            IFluidHandler cap;
            if (tile instanceof net.minecraftforge.fluids.IFluidHandler) {
                return ((net.minecraftforge.fluids.IFluidHandler)tile).fill(from, resource, doFill);
            }
            if (tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, from) && (cap = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, from)) != null) {
                return cap.fill(resource, doFill);
            }
        }
        return 0;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        TileEntity tile;
        if (this.isBoundThingInRange() && (tile = this.field_145850_b.func_175625_s(this.boundPosition)) != null) {
            IFluidHandler cap;
            if (tile instanceof net.minecraftforge.fluids.IFluidHandler) {
                return ((net.minecraftforge.fluids.IFluidHandler)tile).drain(from, resource, doDrain);
            }
            if (tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, from) && (cap = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, from)) != null) {
                return cap.drain(resource, doDrain);
            }
        }
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        TileEntity tile;
        if (this.isBoundThingInRange() && (tile = this.field_145850_b.func_175625_s(this.boundPosition)) != null) {
            IFluidHandler cap;
            if (tile instanceof net.minecraftforge.fluids.IFluidHandler) {
                return ((net.minecraftforge.fluids.IFluidHandler)tile).drain(from, maxDrain, doDrain);
            }
            if (tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, from) && (cap = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, from)) != null) {
                return cap.drain(maxDrain, doDrain);
            }
        }
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        TileEntity tile;
        if (this.isBoundThingInRange() && (tile = this.field_145850_b.func_175625_s(this.boundPosition)) != null) {
            IFluidHandler cap;
            if (tile instanceof net.minecraftforge.fluids.IFluidHandler) {
                return ((net.minecraftforge.fluids.IFluidHandler)tile).canFill(from, fluid);
            }
            if (tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, from) && (cap = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, from)) != null) {
                FluidStack stack = new FluidStack(fluid, 1);
                IFluidTankProperties[] props = cap.getTankProperties();
                if (props != null) {
                    for (IFluidTankProperties prop : props) {
                        if (!prop.canFillFluidType(stack)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        TileEntity tile;
        if (this.isBoundThingInRange() && (tile = this.field_145850_b.func_175625_s(this.boundPosition)) != null) {
            IFluidHandler cap;
            if (tile instanceof net.minecraftforge.fluids.IFluidHandler) {
                return ((net.minecraftforge.fluids.IFluidHandler)tile).canDrain(from, fluid);
            }
            if (tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, from) && (cap = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, from)) != null) {
                FluidStack stack = new FluidStack(fluid, 1);
                IFluidTankProperties[] props = cap.getTankProperties();
                if (props != null) {
                    for (IFluidTankProperties prop : props) {
                        if (!prop.canDrainFluidType(stack)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.boundPosition);
        if (tile instanceof net.minecraftforge.fluids.IFluidHandler) {
            return ((net.minecraftforge.fluids.IFluidHandler)tile).getTankInfo(from);
        }
        return new FluidTankInfo[0];
    }

    @Override
    public int getFluidAmountToSplitShare() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean doesShareFluid() {
        return true;
    }

    @Override
    public EnumFacing[] getFluidShareSides() {
        return EnumFacing.values();
    }
}

