/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.network;

import de.ellpeck.actuallyadditions.mod.data.PlayerData;
import de.ellpeck.actuallyadditions.mod.network.IDataHandler;
import de.ellpeck.actuallyadditions.mod.network.PacketClientToServer;
import de.ellpeck.actuallyadditions.mod.network.PacketServerToClient;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.network.gui.INumberReactor;
import de.ellpeck.actuallyadditions.mod.network.gui.IStringReactor;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class PacketHandler {
    public static final List<IDataHandler> DATA_HANDLERS = new ArrayList<IDataHandler>();
    public static final IDataHandler PARTICLE_HANDLER = new IDataHandler(){

        @Override
        @SideOnly(value=Side.CLIENT)
        public void handleData(NBTTagCompound compound) {
            AssetUtil.spawnLaserWithTimeClient(compound.func_74769_h("StartX"), compound.func_74769_h("StartY"), compound.func_74769_h("StartZ"), compound.func_74769_h("EndX"), compound.func_74769_h("EndY"), compound.func_74769_h("EndZ"), new float[]{compound.func_74760_g("Color1"), compound.func_74760_g("Color2"), compound.func_74760_g("Color3")}, compound.func_74762_e("MaxAge"), compound.func_74769_h("RotationTime"), compound.func_74760_g("Size"), compound.func_74760_g("Alpha"));
        }
    };
    public static final IDataHandler TILE_ENTITY_HANDLER = new IDataHandler(){

        @Override
        @SideOnly(value=Side.CLIENT)
        public void handleData(NBTTagCompound compound) {
            TileEntity tile;
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (world != null && (tile = world.func_175625_s(new BlockPos(compound.func_74762_e("X"), compound.func_74762_e("Y"), compound.func_74762_e("Z")))) instanceof TileEntityBase) {
                ((TileEntityBase)tile).readSyncableNBT(compound.func_74775_l("Data"), TileEntityBase.NBTType.SYNC);
            }
        }
    };
    public static final IDataHandler GUI_BUTTON_TO_TILE_HANDLER = new IDataHandler(){

        @Override
        public void handleData(NBTTagCompound compound) {
            WorldServer world = DimensionManager.getWorld((int)compound.func_74762_e("WorldID"));
            TileEntity tile = world.func_175625_s(new BlockPos(compound.func_74762_e("X"), compound.func_74762_e("Y"), compound.func_74762_e("Z")));
            if (tile instanceof IButtonReactor) {
                IButtonReactor reactor = (IButtonReactor)tile;
                Entity entity = world.func_73045_a(compound.func_74762_e("PlayerID"));
                if (entity instanceof EntityPlayer) {
                    reactor.onButtonPressed(compound.func_74762_e("ButtonID"), (EntityPlayer)entity);
                }
            }
        }
    };
    public static final IDataHandler GUI_BUTTON_TO_CONTAINER_HANDLER = new IDataHandler(){

        @Override
        public void handleData(NBTTagCompound compound) {
            Container container;
            WorldServer world = DimensionManager.getWorld((int)compound.func_74762_e("WorldID"));
            Entity entity = world.func_73045_a(compound.func_74762_e("PlayerID"));
            if (entity instanceof EntityPlayer && (container = ((EntityPlayer)entity).field_71070_bA) instanceof IButtonReactor) {
                ((IButtonReactor)container).onButtonPressed(compound.func_74762_e("ButtonID"), (EntityPlayer)entity);
            }
        }
    };
    public static final IDataHandler GUI_NUMBER_TO_TILE_HANDLER = new IDataHandler(){

        @Override
        public void handleData(NBTTagCompound compound) {
            WorldServer world = DimensionManager.getWorld((int)compound.func_74762_e("WorldID"));
            TileEntity tile = world.func_175625_s(new BlockPos(compound.func_74762_e("X"), compound.func_74762_e("Y"), compound.func_74762_e("Z")));
            if (tile instanceof INumberReactor) {
                INumberReactor reactor = (INumberReactor)tile;
                reactor.onNumberReceived(compound.func_74762_e("Number"), compound.func_74762_e("NumberID"), (EntityPlayer)world.func_73045_a(compound.func_74762_e("PlayerID")));
            }
        }
    };
    public static final IDataHandler GUI_STRING_TO_TILE_HANDLER = new IDataHandler(){

        @Override
        public void handleData(NBTTagCompound compound) {
            WorldServer world = DimensionManager.getWorld((int)compound.func_74762_e("WorldID"));
            TileEntity tile = world.func_175625_s(new BlockPos(compound.func_74762_e("X"), compound.func_74762_e("Y"), compound.func_74762_e("Z")));
            if (tile instanceof IStringReactor) {
                IStringReactor reactor = (IStringReactor)tile;
                reactor.onTextReceived(compound.func_74779_i("Text"), compound.func_74762_e("TextID"), (EntityPlayer)world.func_73045_a(compound.func_74762_e("PlayerID")));
            }
        }
    };
    public static final IDataHandler CHANGE_PLAYER_DATA_HANDLER = new IDataHandler(){

        @Override
        public void handleData(NBTTagCompound compound) {
            NBTTagCompound data = compound.func_74775_l("Data");
            UUID id = compound.func_186857_a("UUID");
            PlayerData.getDataFromPlayer(id).readFromNBT(data);
            if (compound.func_74767_n("Log")) {
                ModUtil.LOGGER.info("Receiving (new or changed) Player Data for player with UUID " + id + ".");
            }
        }
    };
    public static SimpleNetworkWrapper theNetwork;

    public static void init() {
        theNetwork = NetworkRegistry.INSTANCE.newSimpleChannel("actuallyadditions");
        theNetwork.registerMessage(PacketServerToClient.Handler.class, PacketServerToClient.class, 0, Side.CLIENT);
        theNetwork.registerMessage(PacketClientToServer.Handler.class, PacketClientToServer.class, 1, Side.SERVER);
        DATA_HANDLERS.add(PARTICLE_HANDLER);
        DATA_HANDLERS.add(TILE_ENTITY_HANDLER);
        DATA_HANDLERS.add(GUI_BUTTON_TO_TILE_HANDLER);
        DATA_HANDLERS.add(GUI_STRING_TO_TILE_HANDLER);
        DATA_HANDLERS.add(GUI_NUMBER_TO_TILE_HANDLER);
        DATA_HANDLERS.add(CHANGE_PLAYER_DATA_HANDLER);
        DATA_HANDLERS.add(GUI_BUTTON_TO_CONTAINER_HANDLER);
    }
}

