/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.booklet.gui;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.booklet.internal.GuiBookletBase;
import de.ellpeck.actuallyadditions.mod.booklet.button.BookmarkButton;
import de.ellpeck.actuallyadditions.mod.booklet.gui.GuiEntry;
import de.ellpeck.actuallyadditions.mod.booklet.gui.GuiMainPage;
import de.ellpeck.actuallyadditions.mod.data.PlayerData;
import de.ellpeck.actuallyadditions.mod.inventory.gui.TexturedButton;
import de.ellpeck.actuallyadditions.mod.network.PacketHandlerHelper;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public abstract class GuiBooklet
extends GuiBookletBase {
    public static final int BUTTONS_PER_PAGE = 12;
    public static final ResourceLocation RES_LOC_GUI = AssetUtil.getBookletGuiLocation("guiBooklet");
    public static final ResourceLocation RES_LOC_GADGETS = AssetUtil.getBookletGuiLocation("guiBookletGadgets");
    protected final BookmarkButton[] bookmarkButtons = new BookmarkButton[12];
    public GuiScreen previousScreen;
    public GuiBookletBase parentPage;
    public GuiTextField searchField;
    protected int xSize;
    protected int ySize;
    protected int guiLeft;
    protected int guiTop;
    private GuiButton buttonLeft;
    private GuiButton buttonRight;
    private GuiButton buttonBack;

    public GuiBooklet(GuiScreen previousScreen, GuiBookletBase parentPage) {
        this.previousScreen = previousScreen;
        this.parentPage = parentPage;
        this.xSize = 281;
        this.ySize = 180;
    }

    public void func_73866_w_() {
        List<String> hoverText;
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        if (this.hasPageLeftButton()) {
            hoverText = Arrays.asList(TextFormatting.GOLD + "Previous Page", TextFormatting.ITALIC + "Or scroll up");
            this.buttonLeft = new TexturedButton(RES_LOC_GADGETS, -2000, this.guiLeft - 12, this.guiTop + this.ySize - 8, 18, 54, 18, 10, hoverText);
            this.field_146292_n.add(this.buttonLeft);
        }
        if (this.hasPageRightButton()) {
            hoverText = Arrays.asList(TextFormatting.GOLD + "Next Page", TextFormatting.ITALIC + "Or scroll down");
            this.buttonRight = new TexturedButton(RES_LOC_GADGETS, -2001, this.guiLeft + this.xSize - 6, this.guiTop + this.ySize - 8, 0, 54, 18, 10, hoverText);
            this.field_146292_n.add(this.buttonRight);
        }
        if (this.hasBackButton()) {
            hoverText = Arrays.asList(TextFormatting.GOLD + "Go Back", TextFormatting.ITALIC + "Or right-click", TextFormatting.ITALIC.toString() + TextFormatting.GRAY + "Hold Shift for Main Page");
            this.buttonBack = new TexturedButton(RES_LOC_GADGETS, -2002, this.guiLeft - 15, this.guiTop - 3, 36, 54, 18, 10, hoverText);
            this.field_146292_n.add(this.buttonBack);
        }
        if (this.hasSearchBar()) {
            this.searchField = new GuiTextField(-420, this.field_146289_q, this.guiLeft + this.xSize + 2, this.guiTop + this.ySize - 40 + 2, 64, 12);
            this.searchField.func_146203_f(50);
            this.searchField.func_146185_a(false);
        }
        if (this.hasBookmarkButtons()) {
            PlayerData.PlayerSave data = PlayerData.getDataFromPlayer((EntityPlayer)this.field_146297_k.field_71439_g);
            int xStart = this.guiLeft + this.xSize / 2 - 16 * this.bookmarkButtons.length / 2;
            for (int i = 0; i < this.bookmarkButtons.length; ++i) {
                this.bookmarkButtons[i] = new BookmarkButton(1337 + i, xStart + i * 16, this.guiTop + this.ySize, this);
                this.field_146292_n.add(this.bookmarkButtons[i]);
                if (data.bookmarks[i] == null) continue;
                this.bookmarkButtons[i].assignedPage = data.bookmarks[i];
            }
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.previousScreen = null;
        PlayerData.PlayerSave data = PlayerData.getDataFromPlayer((EntityPlayer)this.field_146297_k.field_71439_g);
        boolean change = false;
        for (int i = 0; i < this.bookmarkButtons.length; ++i) {
            if (data.bookmarks[i] == this.bookmarkButtons[i].assignedPage) continue;
            data.bookmarks[i] = this.bookmarkButtons[i].assignedPage;
            change = true;
        }
        data.lastOpenBooklet = this;
        if (change) {
            PacketHandlerHelper.sendPlayerDataPacket((EntityPlayer)this.field_146297_k.field_71439_g, true, false);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.drawScreenPre(mouseX, mouseY, partialTicks);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawScreenPost(mouseX, mouseY, partialTicks);
    }

    public void drawScreenPre(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(RES_LOC_GUI);
        GuiBooklet.func_146110_a((int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)this.xSize, (int)this.ySize, (float)512.0f, (float)512.0f);
        if (this.hasSearchBar()) {
            this.field_146297_k.func_110434_K().func_110577_a(RES_LOC_GADGETS);
            this.func_73729_b(this.guiLeft + this.xSize, this.guiTop + this.ySize - 40, 188, 0, 68, 14);
            boolean unicodeBefore = this.field_146289_q.func_82883_a();
            this.field_146289_q.func_78264_a(true);
            if (!this.searchField.func_146206_l() && (this.searchField.func_146179_b() == null || this.searchField.func_146179_b().isEmpty())) {
                this.field_146289_q.func_175065_a(TextFormatting.ITALIC + "Click to search...", (float)(this.guiLeft + this.xSize + 2), (float)(this.guiTop + this.ySize - 40 + 2), 0xFFFFFF, false);
            }
            this.searchField.func_146194_f();
            this.field_146289_q.func_78264_a(unicodeBefore);
        }
    }

    public void drawScreenPost(int mouseX, int mouseY, float partialTicks) {
        for (GuiButton button : this.field_146292_n) {
            if (button instanceof BookmarkButton) {
                ((BookmarkButton)button).drawHover(mouseX, mouseY);
                continue;
            }
            if (!(button instanceof TexturedButton)) continue;
            ((TexturedButton)button).drawHover(mouseX, mouseY);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.hasSearchBar()) {
            this.searchField.func_146192_a(mouseX, mouseY, mouseButton);
        }
        if (mouseButton == 1 && this.hasBackButton()) {
            this.onBackButtonPressed();
        }
    }

    public void func_146274_d() throws IOException {
        int wheel = Mouse.getEventDWheel();
        if (wheel != 0) {
            if (wheel < 0) {
                if (this.hasPageRightButton()) {
                    this.onPageRightButtonPressed();
                }
            } else if (wheel > 0 && this.hasPageLeftButton()) {
                this.onPageLeftButtonPressed();
            }
        }
        super.func_146274_d();
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.hasSearchBar()) {
            this.searchField.func_146178_a();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public boolean hasPageLeftButton() {
        return false;
    }

    public void onPageLeftButtonPressed() {
    }

    public boolean hasPageRightButton() {
        return false;
    }

    public void onPageRightButtonPressed() {
    }

    public boolean hasBackButton() {
        return false;
    }

    public void onBackButtonPressed() {
        this.field_146297_k.func_147108_a((GuiScreen)new GuiMainPage(this.previousScreen));
    }

    public boolean hasSearchBar() {
        return true;
    }

    public boolean hasBookmarkButtons() {
        return true;
    }

    public void onSearchBarChanged(String searchBarText) {
        GuiBookletBase parent = !(this instanceof GuiEntry) ? this : this.parentPage;
        this.field_146297_k.func_147108_a((GuiScreen)new GuiEntry(this.previousScreen, parent, ActuallyAdditionsAPI.allAndSearch, 0, searchBarText, true));
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (this.hasPageLeftButton() && button == this.buttonLeft) {
            this.onPageLeftButtonPressed();
        } else if (this.hasPageRightButton() && button == this.buttonRight) {
            this.onPageRightButtonPressed();
        } else if (this.hasBackButton() && button == this.buttonBack) {
            this.onBackButtonPressed();
        } else if (this.hasBookmarkButtons() && button instanceof BookmarkButton) {
            int index = ArrayUtils.indexOf((Object[])this.bookmarkButtons, (Object)button);
            if (index >= 0) {
                this.bookmarkButtons[index].onPressed();
            }
        } else {
            super.func_146284_a(button);
        }
    }

    protected void func_73869_a(char typedChar, int key) throws IOException {
        if (key == 1 || key == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i() && (!this.hasSearchBar() || !this.searchField.func_146206_l())) {
            this.field_146297_k.func_147108_a(this.previousScreen);
        } else if (this.hasSearchBar() & this.searchField.func_146206_l()) {
            String lastText = this.searchField.func_146179_b();
            this.searchField.func_146201_a(typedChar, key);
            if (!lastText.equals(this.searchField.func_146179_b())) {
                this.onSearchBarChanged(this.searchField.func_146179_b());
            }
        } else {
            super.func_73869_a(typedChar, key);
        }
    }

    @Override
    public void renderScaledAsciiString(String text, int x, int y, int color, boolean shadow, float scale) {
        StringUtil.renderScaledAsciiString(this.field_146289_q, text, x, y, color, shadow, scale);
    }

    @Override
    public void renderSplitScaledAsciiString(String text, int x, int y, int color, boolean shadow, float scale, int length) {
        StringUtil.renderSplitScaledAsciiString(this.field_146289_q, text, x, y, color, shadow, scale, length);
    }

    @Override
    public List<GuiButton> getButtonList() {
        return this.field_146292_n;
    }

    @Override
    public int getGuiLeft() {
        return this.guiLeft;
    }

    @Override
    public int getGuiTop() {
        return this.guiTop;
    }

    @Override
    public int getSizeX() {
        return this.xSize;
    }

    @Override
    public int getSizeY() {
        return this.ySize;
    }
}

