/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.booklet.entry;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.booklet.IBookletChapter;
import de.ellpeck.actuallyadditions.api.booklet.IBookletEntry;
import de.ellpeck.actuallyadditions.api.booklet.IBookletPage;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BookletEntry
implements IBookletEntry {
    private final String identifier;
    private final List<IBookletChapter> chapters = new ArrayList<IBookletChapter>();
    private TextFormatting color;

    public BookletEntry(String identifier) {
        this.identifier = identifier;
        ActuallyAdditionsAPI.addBookletEntry(this);
        this.color = TextFormatting.RESET;
    }

    @SideOnly(value=Side.CLIENT)
    private static boolean fitsFilter(IBookletPage page, String searchBarText) {
        Minecraft mc = Minecraft.func_71410_x();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        page.getItemStacksForPage(items);
        if (!items.isEmpty()) {
            for (ItemStack stack : items) {
                if (!StackUtil.isValid(stack)) continue;
                List tooltip = stack.func_82840_a((EntityPlayer)mc.field_71439_g, mc.field_71474_y.field_82882_x);
                for (String strg : tooltip) {
                    if (strg == null || !strg.toLowerCase(Locale.ROOT).contains(searchBarText)) continue;
                    return true;
                }
            }
        }
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        page.getFluidStacksForPage(fluids);
        if (!fluids.isEmpty()) {
            for (FluidStack stack : fluids) {
                String strg;
                if (stack == null || (strg = stack.getLocalizedName()) == null || !strg.toLowerCase(Locale.ROOT).contains(searchBarText)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<IBookletChapter> getAllChapters() {
        return this.chapters;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getLocalizedName() {
        return StringUtil.localize("booklet.actuallyadditions.indexEntry." + this.getIdentifier() + ".name");
    }

    @Override
    public String getLocalizedNameWithFormatting() {
        return this.color + this.getLocalizedName();
    }

    @Override
    public void addChapter(IBookletChapter chapter) {
        this.chapters.add(chapter);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBookletChapter> getChaptersForDisplay(String searchBarText) {
        if (searchBarText != null && !searchBarText.isEmpty()) {
            String search = searchBarText.toLowerCase(Locale.ROOT);
            ArrayList<IBookletChapter> fittingChapters = new ArrayList<IBookletChapter>();
            block0: for (IBookletChapter chapter : this.getAllChapters()) {
                if (chapter.getLocalizedName().toLowerCase(Locale.ROOT).contains(search)) {
                    fittingChapters.add(chapter);
                    continue;
                }
                for (IBookletPage page : chapter.getAllPages()) {
                    if (!BookletEntry.fitsFilter(page, search)) continue;
                    fittingChapters.add(chapter);
                    continue block0;
                }
            }
            return fittingChapters;
        }
        return this.getAllChapters();
    }

    public BookletEntry setImportant() {
        this.color = TextFormatting.DARK_GREEN;
        return this;
    }

    public BookletEntry setSpecial() {
        this.color = TextFormatting.DARK_PURPLE;
        return this;
    }
}

