/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.inventory;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.IItemHandler;
import sonar.core.api.SonarAPI;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.api.utils.ActionType;
import sonar.core.helpers.InventoryHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.inventory.ISonarInventory;
import sonar.core.network.sync.DirtyPart;
import sonar.core.network.sync.ISyncPart;

public abstract class AbstractSonarInventory<T extends AbstractSonarInventory>
extends DirtyPart
implements ISonarInventory,
ISyncPart {
    public ItemStack[] slots;
    public int limit = 64;
    public EnumFacing face = null;
    public IItemHandler embeddedHandler = new EmbeddedHandler(this);

    public AbstractSonarInventory(int size) {
        this.slots = new ItemStack[size];
    }

    @Override
    public IItemHandler getItemHandler(EnumFacing side) {
        this.face = side;
        return this.embeddedHandler;
    }

    public T setStackLimit(int limit) {
        this.limit = limit;
        return (T)this;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (this.canSync(type)) {
            NBTTagList list = nbt.func_150295_c(this.getTagName(), 10);
            this.slots = new ItemStack[this.func_70302_i_()];
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                byte b = compound.func_74771_c("Slot");
                if (b < 0 || b >= this.slots.length) continue;
                this.slots[b] = ItemStack.func_77949_a((NBTTagCompound)compound);
            }
        }
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (this.canSync(type)) {
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < this.slots.length; ++i) {
                if (this.slots[i] == null) continue;
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74774_a("Slot", (byte)i);
                this.slots[i].func_77955_b(compound);
                list.func_74742_a((NBTBase)compound);
            }
            nbt.func_74782_a(this.getTagName(), (NBTBase)list);
        }
        return nbt;
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.slots[slot];
    }

    public ItemStack func_70298_a(int slot, int var2) {
        if (this.slots[slot] != null) {
            if (this.slots[slot].field_77994_a <= var2) {
                ItemStack itemstack = this.slots[slot];
                this.slots[slot] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.slots[slot].func_77979_a(var2);
            if (this.slots[slot].field_77994_a == 0) {
                this.slots[slot] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemstack = this.slots[i];
            this.slots[i] = null;
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.slots[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return this.limit;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70299_a(i, null);
        }
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.readData(ByteBufUtils.readTag((ByteBuf)buf), NBTHelper.SyncType.SAVE);
    }

    @Override
    public boolean canSync(NBTHelper.SyncType sync) {
        return sync.isType(this.getSyncTypes());
    }

    public NBTHelper.SyncType[] getSyncTypes() {
        return new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE};
    }

    @Override
    public String getTagName() {
        return "Items";
    }

    public int getSlots() {
        return this.func_70302_i_();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        StoredItemStack add = new StoredItemStack(stack);
        boolean bool = InventoryHelper.addStack(this, add, slot, this.func_70297_j_(), ActionType.getTypeForAction(simulate));
        return bool ? add.getActualStack() : null;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stored = this.func_70301_a(slot);
        if (stored == null || stored.field_77994_a == 0 || amount == 0) {
            return null;
        }
        StoredItemStack remove = new StoredItemStack(stored, amount);
        boolean bool = InventoryHelper.removeStack(this, remove, stored, slot, ActionType.getTypeForAction(simulate));
        remove = SonarAPI.getItemHelper().getStackToAdd(amount, new StoredItemStack(stored), remove);
        return remove.getActualStack();
    }

    public static class EmbeddedHandler
    implements IItemHandler {
        AbstractSonarInventory inv;

        public EmbeddedHandler(AbstractSonarInventory inv) {
            this.inv = inv;
        }

        public int getSlots() {
            return this.inv.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.inv.func_70301_a(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.inv.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.inv.extractItem(slot, amount, simulate);
        }
    }
}

