/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.common.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.core.helpers.FontHelper;
import sonar.core.integration.SonarLoader;

public class SonarSeedsFood
extends ItemFood
implements IPlantable {
    private Block cropBlock;
    private Block soilId;
    public int greenhouseTier;

    public SonarSeedsFood(int hunger, float saturation, Block crop, Block soil, int tier) {
        super(hunger, saturation, false);
        this.cropBlock = crop;
        this.soilId = soil;
        this.greenhouseTier = tier;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(stack, player, list, par4);
        if (SonarLoader.calculatorLoaded()) {
            String mode = FontHelper.translate("calculator.tools.calculator.greenhouse");
            switch (this.greenhouseTier) {
                case 0: {
                    break;
                }
                case 1: {
                    list.add(FontHelper.translate("Planted with Basic Greenhouse or Higher"));
                    break;
                }
                case 2: {
                    list.add(FontHelper.translate("Planted with Advanced Greenhouse or Higher"));
                    break;
                }
                case 3: {
                    list.add(FontHelper.translate("Planted with Flawless Greenhouse"));
                }
            }
        }
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.greenhouseTier == 0 || !SonarLoader.calculatorLoaded()) {
            if (side != EnumFacing.UP) {
                return EnumActionResult.PASS;
            }
            if (player.func_175151_a(pos, side, stack) && player.func_175151_a(pos.func_177972_a(EnumFacing.UP), side, stack)) {
                IBlockState state = world.func_180495_p(pos);
                if (state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)this) && world.func_175623_d(pos.func_177972_a(EnumFacing.UP))) {
                    world.func_175656_a(pos.func_177972_a(side), this.cropBlock.func_176223_P());
                    --stack.field_77994_a;
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.PASS;
            }
            return EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return this.cropBlock == Blocks.field_150388_bm ? EnumPlantType.Nether : EnumPlantType.Crop;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.cropBlock.func_176223_P();
    }

    public boolean canTierUse(int tier) {
        return tier >= this.greenhouseTier;
    }
}

