/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.api.inventories;

import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import sonar.core.api.ISonarStack;
import sonar.core.helpers.NBTHelper;

public class StoredItemStack
implements ISonarStack<StoredItemStack> {
    public ItemStack item;
    public long stored;

    public StoredItemStack() {
    }

    public StoredItemStack(ItemStack stack) {
        this.item = stack.func_77946_l();
        this.stored = stack.field_77994_a;
    }

    public StoredItemStack(ItemStack stack, long stored) {
        this.item = stack.func_77946_l();
        this.stored = stored;
    }

    @Override
    public void add(ItemStack stack) {
        if (this.equalStack(stack)) {
            this.stored += (long)stack.field_77994_a;
        }
    }

    @Override
    public void remove(ItemStack stack) {
        if (this.equalStack(stack)) {
            this.stored -= (long)stack.field_77994_a;
        }
    }

    @Override
    public void add(StoredItemStack stack) {
        if (this.equalStack(stack.item)) {
            this.stored += stack.stored;
        }
    }

    @Override
    public void remove(StoredItemStack stack) {
        if (this.equalStack(stack.item)) {
            this.stored -= stack.stored;
        }
    }

    @Override
    public StoredItemStack copy() {
        return new StoredItemStack(this.item, this.stored);
    }

    @Override
    public StoredItemStack setStackSize(long size) {
        this.stored = size;
        return this;
    }

    public StoredItemStack setStackSize(StoredItemStack stack) {
        this.stored = stack == null ? 0L : stack.getStackSize();
        return this;
    }

    public boolean equalStack(ItemStack stack) {
        if (this.item == null || stack == null) {
            return false;
        }
        if (!this.item.func_77969_a(stack)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.item);
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.item = ItemStack.func_77949_a((NBTTagCompound)nbt);
        this.stored = nbt.func_74763_f("stored");
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.item.func_77955_b(nbt);
        nbt.func_74772_a("stored", this.stored);
        return nbt;
    }

    public static StoredItemStack readFromBuf(ByteBuf buf) {
        return new StoredItemStack(ByteBufUtils.readItemStack((ByteBuf)buf), buf.readLong());
    }

    public static void writeToBuf(ByteBuf buf, StoredItemStack storedStack) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)storedStack.item);
        buf.writeLong(storedStack.stored);
    }

    public boolean equals(Object obj) {
        if (obj instanceof StoredItemStack) {
            StoredItemStack target = (StoredItemStack)obj;
            if (this.equalStack(target.item) && this.stored == target.stored) {
                return true;
            }
        }
        return false;
    }

    public ItemStack getItemStack() {
        return this.item;
    }

    @Override
    public long getStackSize() {
        return this.stored;
    }

    public int getValidStackSize() {
        return (int)Math.min(this.stored, (long)this.item.func_77976_d());
    }

    public int getItemDamage() {
        return this.item.func_77952_i();
    }

    public NBTTagCompound getTagCompound() {
        return this.item.func_77978_p();
    }

    public ItemStack getFullStack() {
        int min = this.getValidStackSize();
        ItemStack stack = this.item.func_77946_l();
        stack.field_77994_a = min;
        return stack;
    }

    public ItemStack getActualStack() {
        ItemStack fullStack = this.getFullStack();
        if (fullStack.field_77994_a <= 0) {
            return null;
        }
        return fullStack;
    }

    public static ItemStack getActualStack(StoredItemStack stack) {
        if (stack == null) {
            return null;
        }
        return stack.getActualStack();
    }

    @Override
    public ISonarStack.StorageTypes getStorageType() {
        return ISonarStack.StorageTypes.ITEMS;
    }

    public String toString() {
        if (this.item != null) {
            return this.stored + "x" + this.item.func_77977_a() + "@" + this.item.func_77952_i();
        }
        return super.toString() + " : NULL";
    }
}

