/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.rwtema.extrautils2.compatibility.CompatHelper;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.gui.backend.WidgetTextData;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.power.PowerManager;
import com.rwtema.extrautils2.transfernodes.Grocket;
import com.rwtema.extrautils2.transfernodes.IBuffer;
import com.rwtema.extrautils2.transfernodes.IPipe;
import com.rwtema.extrautils2.transfernodes.IUpgradeProvider;
import com.rwtema.extrautils2.transfernodes.Ping;
import com.rwtema.extrautils2.transfernodes.TransferHelper;
import com.rwtema.extrautils2.transfernodes.Upgrade;
import com.rwtema.extrautils2.utils.CapGetter;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.datastructures.ArrayAccess;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TObjectIntProcedure;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TransferNodeBase<T>
extends Grocket
implements ITickable,
IBuffer {
    protected final Ping ping = this.registerNBT("ping", new Ping());
    protected int cooldown = 0;
    protected float power = Float.NaN;
    TObjectIntHashMap<Upgrade> upgrades;
    public ItemStackHandler upgradeHandler = this.registerNBT("upgrades", new ItemStackHandler(6){
        public final TObjectIntProcedure<Upgrade> loadUpgradePower;
        {
            this.loadUpgradePower = (a, b) -> {
                float powerUse = a.getPowerUse(b);
                TransferNodeBase.this.power = Float.isNaN(TransferNodeBase.this.power) ? powerUse : (TransferNodeBase.this.power += powerUse);
                return true;
            };
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            if (!(stack.func_77973_b() instanceof IUpgradeProvider)) {
                return 0;
            }
            Upgrade upgrade = ((IUpgradeProvider)stack.func_77973_b()).getUpgrade(stack);
            if (upgrade == null) {
                return 0;
            }
            ArrayAccess<ItemStack> arrayAccess = CompatHelper.getArray10List11(this.stacks);
            for (int i = 0; i < arrayAccess.length(); ++i) {
                ItemStack otherStack;
                if (i == slot || !StackHelper.isNonNull(otherStack = arrayAccess.get(i)) || otherStack == null) continue;
                if (StackHelper.isNonNull(otherStack) && ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)otherStack)) {
                    return 0;
                }
                Item item = otherStack.func_77973_b();
                if (!(item instanceof IUpgradeProvider) || ((IUpgradeProvider)item).getUpgrade(otherStack) != upgrade) continue;
                return 0;
            }
            return upgrade.maxLevel;
        }

        protected void onContentsChanged(int slot) {
            TransferNodeBase.this.markDirty();
            float prevPower = TransferNodeBase.this.power;
            this.loadUpgrades();
            if (Float.floatToIntBits(prevPower) != Float.floatToIntBits(TransferNodeBase.this.power) && TransferNodeBase.this.holder != null) {
                PowerManager.instance.markDirty(TransferNodeBase.this.holder);
            }
        }

        protected void onLoad() {
            this.loadUpgrades();
        }

        public void loadUpgrades() {
            float p = Float.NaN;
            TObjectIntHashMap upgradeMap = new TObjectIntHashMap(10, 0.5f, 0);
            for (ItemStack stack : this.stacks) {
                if (!StackHelper.isNonNull(stack) || !(stack.func_77973_b() instanceof IUpgradeProvider)) continue;
                upgradeMap.adjustOrPutValue((Object)((IUpgradeProvider)stack.func_77973_b()).getUpgrade(stack), StackHelper.getStacksize(stack), StackHelper.getStacksize(stack));
            }
            TransferNodeBase.this.power = Float.NaN;
            upgradeMap.forEachEntry(this.loadUpgradePower);
            TransferNodeBase.this.upgrades = upgradeMap;
        }
    });
    private byte rareTickOnce;

    public int getUpgradeLevel(Upgrade upgrade) {
        TObjectIntHashMap<Upgrade> upgrades = this.upgrades;
        if (upgrades == null) {
            return upgrade.getModifierLevel(0);
        }
        int level = upgrades.get((Object)upgrade);
        if (level < 0) {
            level = 0;
        }
        if (level > upgrade.maxLevel) {
            level = upgrade.maxLevel;
        }
        return upgrade.getModifierLevel(level);
    }

    @Override
    public void func_73660_a() {
        if (this.holder == null) {
            return;
        }
        World world = this.holder.func_145831_w();
        if (world.func_82737_E() % 16L == 0L) {
            this.rareTickOnce = this.rareTickOnce == 0 ? (byte)1 : (byte)2;
        } else if (this.rareTickOnce != 0) {
            this.rareTickOnce = 0;
        }
        if (this.ping.needsInit()) {
            this.ping.init((IBlockAccess)world, this.holder.func_174877_v(), this.side.func_176734_d(), this);
            return;
        }
        if (this.cooldown > 0) {
            this.cooldown -= this.stepCooldown();
        }
        if (this.checkRedstone()) {
            this.cooldown = 20;
            return;
        }
        T attached = this.getAttached();
        while (this.cooldown <= 0) {
            this.cooldown += 20;
            this.processBuffer(attached);
            if (this.shouldAdvance()) {
                BlockPos pingPos = this.ping.getPos();
                if (pingPos == null) {
                    return;
                }
                if (!world.func_175667_e(pingPos)) {
                    this.ping.resetPosition();
                    return;
                }
                IPipe pipe = TransferHelper.getPipe((IBlockAccess)world, pingPos);
                if (!this.processPosition(pingPos, attached, pipe)) continue;
                this.ping.advanceSearch(pipe);
                continue;
            }
            this.ping.resetPosition();
        }
    }

    protected abstract boolean shouldAdvance();

    protected abstract void processBuffer(@Nullable T var1);

    protected abstract boolean processPosition(BlockPos var1, T var2, IPipe var3);

    private int stepCooldown() {
        return 1 + this.getUpgradeLevel(Upgrade.SPEED);
    }

    public boolean checkRedstone() {
        return this.holder.func_145831_w().func_175640_z(this.holder.func_174877_v());
    }

    public T getAttached() {
        TileEntity tile = this.holder.func_145831_w().func_175625_s(this.holder.func_174877_v().func_177972_a(this.side));
        if (tile == null) {
            return null;
        }
        T capability1 = this.getHandler(tile);
        if (capability1 != null) {
            return capability1;
        }
        return null;
    }

    public abstract T getHandler(TileEntity var1);

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("Cooldown", this.cooldown);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.cooldown = tag.func_74762_e("Cooldown");
    }

    public <S> boolean hasInterface(TileEntity tileEntity, CapGetter<S> capability) {
        return capability == CapGetter.PipeConnect || super.hasInterface(tileEntity, capability);
    }

    @Override
    public float getPower() {
        return this.power;
    }

    public class WidgetPingPosition
    extends WidgetTextData {
        public WidgetPingPosition(int x, int y) {
            super(x, y, 154);
            this.setAlign(0);
        }

        @Override
        public void addToDescription(XUPacketBuffer packet) {
            packet.writeBlockPos(TransferNodeBase.this.ping.getPos());
        }

        @Override
        protected String constructText(XUPacketBuffer packet) {
            BlockPos pos = packet.readBlockPos();
            pos = pos.func_177973_b((Vec3i)TransferNodeBase.this.holder.func_174877_v());
            return Lang.translateArgs("x = %s, y = %s, z = %s", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }
}

