/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.power.energy;

import net.minecraft.nbt.NBTTagInt;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.EnergyStorage;

public class XUEnergyStorage
extends EnergyStorage
implements INBTSerializable<NBTTagInt> {
    public XUEnergyStorage(int capacity) {
        super(capacity);
    }

    public XUEnergyStorage(int capacity, int maxTransfer) {
        super(capacity, maxTransfer);
    }

    public XUEnergyStorage(int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract);
    }

    public NBTTagInt serializeNBT() {
        if (this.energy < 0) {
            this.energy = 0;
        }
        return new NBTTagInt(this.energy);
    }

    public void deserializeNBT(NBTTagInt nbt) {
        this.energy = nbt.func_150287_d();
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        }
    }

    public XUEnergyStorage setCapacity(int capacity) {
        this.capacity = capacity;
        if (this.energy > capacity) {
            this.energy = capacity;
        }
        return this;
    }

    public XUEnergyStorage setMaxTransfer(int maxTransfer) {
        this.setMaxReceive(maxTransfer);
        this.setMaxExtract(maxTransfer);
        return this;
    }

    public XUEnergyStorage setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
        return this;
    }

    public XUEnergyStorage setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
        return this;
    }

    public int getMaxReceive() {
        return this.maxReceive;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }

    public void setEnergyStored(int energy) {
        this.energy = energy;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0) {
            this.energy = 0;
        }
    }

    public void modifyEnergyStored(int energy) {
        this.energy += energy;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0) {
            this.energy = 0;
        }
    }
}

