/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.machine;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.rwtema.extrautils2.api.machine.MachineSlotFluid;
import com.rwtema.extrautils2.api.machine.MachineSlotItem;
import com.rwtema.extrautils2.machine.EnergyBaseRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

class DischantEnergyRecipe
extends EnergyBaseRecipe {
    DischantEnergyRecipe() {
    }

    @Override
    public int getEnergyOutput(@Nonnull ItemStack stack) {
        if (!stack.func_77948_v() && stack.func_77973_b() != Items.field_151134_bR) {
            return 0;
        }
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (enchantments.isEmpty()) {
            return 0;
        }
        double amount = 0.0;
        for (Map.Entry entry2 : enchantments.entrySet()) {
            Enchantment enchantment = (Enchantment)entry2.getKey();
            if (enchantment == null) continue;
            int rawLevel = (Integer)entry2.getValue();
            int level = 1 + rawLevel;
            int weight = enchantment.func_77324_c().func_185270_a();
            double v = Math.sqrt((double)Math.min(level, enchantment.func_77325_b()) / (double)enchantment.func_77325_b()) * (double)enchantment.func_77325_b() * (double)level * (double)enchantment.func_77325_b();
            amount += v / Math.sqrt(weight) * (double)enchantment.func_77321_a(rawLevel);
        }
        return (int)Math.ceil(amount) * 400;
    }

    @Override
    protected float getEnergyRate(@Nonnull ItemStack stack) {
        return 40.0f;
    }

    @Override
    @Nonnull
    public Collection<ItemStack> getInputValues() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Enchantment enchantment : Enchantment.field_185264_b) {
            for (int i = enchantment.func_77319_d(); i <= enchantment.func_77325_b(); ++i) {
                builder.add((Object)Items.field_151134_bR.func_92111_a(new EnchantmentData(enchantment, i)));
            }
        }
        return builder.build();
    }

    @Override
    public List<Pair<Map<MachineSlotItem, List<ItemStack>>, Map<MachineSlotFluid, List<FluidStack>>>> getJEIInputItemExamples() {
        ArrayList<Pair<Map<MachineSlotItem, List<ItemStack>>, Map<MachineSlotFluid, List<FluidStack>>>> list = new ArrayList<Pair<Map<MachineSlotItem, List<ItemStack>>, Map<MachineSlotFluid, List<FluidStack>>>>();
        for (Enchantment enchantment : Enchantment.field_185264_b) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = enchantment.func_77319_d(); i <= enchantment.func_77325_b(); ++i) {
                builder.add((Object)Items.field_151134_bR.func_92111_a(new EnchantmentData(enchantment, i)));
            }
            list.add((Pair<Map<MachineSlotItem, List<ItemStack>>, Map<MachineSlotFluid, List<FluidStack>>>)Pair.of((Object)ImmutableMap.of((Object)this.inputSlot, (Object)builder.build()), (Object)ImmutableMap.of()));
        }
        return list;
    }
}

