/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.ClientRunnable;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.hud.HUDHandler;
import com.rwtema.extrautils2.hud.IHudHandler;
import com.rwtema.extrautils2.network.NetworkHandler;
import com.rwtema.extrautils2.network.XUPacketClientToServer;
import com.rwtema.extrautils2.power.PowerManager;
import com.rwtema.extrautils2.power.player.PlayerPower;
import com.rwtema.extrautils2.power.player.PlayerPowerManager;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public abstract class PlayerPowerFlightBase
extends PlayerPower {
    protected ItemStack stack;
    int tickFlight = 0;

    public PlayerPowerFlightBase(EntityPlayer player, @Nonnull ItemStack stack) {
        super(player);
        this.stack = stack;
    }

    public abstract int getMaxFlightTime();

    @Override
    public void powerChanged(boolean powered) {
    }

    @Override
    public String getName() {
        return this.stack.func_82833_r();
    }

    @Override
    public boolean shouldSustain(ItemStack stack) {
        return stack.func_77969_a(this.stack);
    }

    public void apply(double y, double motion_y) {
        if (this.tickFlight >= this.getMaxFlightTime() + 20) {
            return;
        }
        ++this.tickFlight;
        EntityPlayer player = this.getPlayer();
        if (motion_y > 0.0) {
            player.field_70143_R = 0.0f;
        } else if (motion_y > -3.92) {
            double altFallDistance = 49.0 * motion_y - 194.03333333333333 * Math.log(1.0 + motion_y / 3.92);
            player.field_70143_R = Math.min(player.field_70143_R, (float)altFallDistance);
        }
        player.field_70163_u = y;
        player.field_70181_x = motion_y;
    }

    public abstract boolean isValid(double var1, double var3);

    static {
        ExtraUtils2.proxy.run(new ClientRunnable(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void run() {
                HUDHandler.register(new IHudHandler(){

                    @Override
                    @SideOnly(value=Side.CLIENT)
                    public void render(GuiIngameForge hud, ScaledResolution resolution, float partialTicks) {
                        PlayerPowerFlightBase client = (PlayerPowerFlightBase)PlayerPowerManager.getClient((Item)XU2Entries.chickenRing.value);
                        if (client == null || client.tickFlight == 0) {
                            return;
                        }
                        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                        if (player == null || player.func_184218_aH()) {
                            return;
                        }
                        Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GlStateManager.func_179084_k();
                        float charge = MathHelper.func_76131_a((float)(1.0f - (float)client.tickFlight / (float)client.getMaxFlightTime()), (float)0.0f, (float)1.0f);
                        int barWidth = 182;
                        int width = resolution.func_78326_a();
                        int height = resolution.func_78328_b();
                        int x = width / 2 - 91;
                        int filled = (int)(charge * 183.0f);
                        int top = height - 32 + 3 - 18;
                        hud.func_73729_b(x, top, 0, 84, 182, 5);
                        if (filled > 0) {
                            hud.func_73729_b(x, top, 0, 89, filled, 5);
                        }
                        GlStateManager.func_179147_l();
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    }
                });
            }
        });
    }

    @NetworkHandler.XUPacket
    public static class PacketFlightData
    extends XUPacketClientToServer {
        double y;
        double motion_y;
        private EntityPlayer player;

        public PacketFlightData() {
        }

        public PacketFlightData(EntityPlayer player) {
            this.y = player.field_70163_u;
            this.motion_y = player.field_70181_x;
        }

        @Override
        public void writeData() throws Exception {
            this.writeDouble(this.y);
            this.writeDouble(this.motion_y);
        }

        @Override
        public void readData(EntityPlayer player) {
            this.player = player;
            this.y = this.readDouble();
            this.motion_y = this.readDouble();
        }

        @Override
        public Runnable doStuffServer() {
            return () -> {
                if (!PowerManager.instance.isPowered((EntityPlayerMP)this.player)) {
                    return;
                }
                PlayerPower playerPower = PlayerPowerManager.get(this.player, (Item)XU2Entries.chickenRing.value);
                if (!(playerPower instanceof PlayerPowerFlightBase)) {
                    return;
                }
                PlayerPowerFlightBase playerPower1 = (PlayerPowerFlightBase)playerPower;
                playerPower1.apply(this.y, this.motion_y);
            };
        }
    }
}

