/*
 * Decompiled with CFR 0.152.
 */
package mcjty.nice.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import mcjty.nice.blocks.CylinderRenderer;
import mcjty.nice.blocks.CylinderTileEntity;
import mcjty.nice.blocks.GenericParticleBlock;
import mcjty.nice.client.BlockColor;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CylinderBlock
extends GenericParticleBlock
implements ITileEntityProvider {
    public static final AxisAlignedBB EMPTY = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");

    public CylinderBlock() {
        super("cylinder");
        GameRegistry.registerTileEntity(CylinderTileEntity.class, (String)"nice_cylinder");
    }

    @Override
    protected IBlockState getState() {
        return super.getState().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initClient() {
        super.initClient();
        ClientRegistry.bindTileEntitySpecialRenderer(CylinderTileEntity.class, (TileEntitySpecialRenderer)new CylinderRenderer());
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return EMPTY;
    }

    @Nonnull
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new CylinderTileEntity();
    }

    protected void clGetSubBlocks(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (BlockColor color : BlockColor.values()) {
            if (color == BlockColor.TRANSP) continue;
            subItems.add(CylinderBlock.makeColoredBlock((Block)this, color, 1));
        }
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)CylinderBlock.getFacingFromEntity(pos, placer)), 2);
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public static EnumFacing getFacingFromEntity(BlockPos clickedBlock, EntityLivingBase entity) {
        return EnumFacing.func_176737_a((float)((float)(entity.field_70165_t - (double)clickedBlock.func_177958_n())), (float)((float)(entity.field_70163_u - (double)clickedBlock.func_177956_o())), (float)((float)(entity.field_70161_v - (double)clickedBlock.func_177952_p())));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, COLOR});
    }
}

