/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.beneath;

import com.shinoow.beneath.common.CommonProxy;
import com.shinoow.beneath.common.block.BlockTeleporterDeepDank;
import com.shinoow.beneath.common.block.tile.TileEntityTeleporterDeepDank;
import com.shinoow.beneath.common.entity.EntityHand;
import com.shinoow.beneath.common.entity.EntityShadow;
import com.shinoow.beneath.common.handler.BeneathEventHandler;
import com.shinoow.beneath.common.handler.OreGenHandler;
import com.shinoow.beneath.common.network.PacketDispatcher;
import com.shinoow.beneath.common.world.WorldProviderDeepDank;
import com.shinoow.beneath.common.world.biome.BiomeDeepDank;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.logging.log4j.Level;

@Mod(modid="beneath", name="The Beneath", version="1.2.0", dependencies="required-after:Forge@[12.18.3.2185,);after:grue@[1.3.4,)", acceptedMinecraftVersions="[1.10.2]", guiFactory="com.shinoow.beneath.client.config.BeneathGuiFactory", useMetadata=false, updateJSON="https://raw.githubusercontent.com/Shinoow/The-Beneath/master/version.json")
public class Beneath {
    public static final String version = "1.2.0";
    public static final String modid = "beneath";
    public static final String name = "The Beneath";
    @Mod.Metadata(value="beneath")
    public static ModMetadata metadata;
    @Mod.Instance(value="beneath")
    public static Beneath instance;
    @SidedProxy(clientSide="com.shinoow.beneath.client.ClientProxy", serverSide="com.shinoow.beneath.common.CommonProxy")
    public static CommonProxy proxy;
    public static Configuration cfg;
    static int startEntityId;
    public static int dim;
    public static int darkTimer;
    public static int darkDamage;
    public static int dungeonChance;
    public static int shadowSpawnWeight;
    public static String mode;
    public static boolean internalOreGen;
    public static boolean keepLoaded;
    public static boolean dimTeleportation;
    public static boolean disableMobSpawning;
    private static boolean useCraftingRecipe;
    private static String[] craftingRecipe;
    public static Biome deep_dank;
    public static DimensionType deep_dank_dim;
    public static Block teleporter;
    public static DamageSource darkness;
    public static SoundEvent beneath_normal;
    public static SoundEvent beneath_muffled;
    public static SoundEvent beneath_drawnout;
    public static SoundEvent deepdank;
    public static SoundEvent dark1;
    public static SoundEvent dark2;
    public static SoundEvent scream;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        metadata = event.getModMetadata();
        Beneath.metadata.description = Beneath.metadata.description + "\n\n\u00a76Supporters: " + this.getSupporterList() + "\u00a7r";
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new BeneathEventHandler());
        instance = this;
        cfg = new Configuration(new File(event.getModConfigurationDirectory(), "/beneath/beneath.cfg"));
        Beneath.syncConfig();
        cfg.setCategoryComment("general", "CONFIG ALL THE THINGS! Any changes take effect after a Minecraft restart (though some can take effect immediately, with weird results).");
        deep_dank = new BiomeDeepDank();
        GameRegistry.register((IForgeRegistryEntry)deep_dank.setRegistryName(new ResourceLocation(modid, "the_beneath")));
        BiomeDictionary.registerBiomeType((Biome)deep_dank, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DEAD});
        deep_dank_dim = DimensionType.register((String)name, (String)"_tb", (int)dim, WorldProviderDeepDank.class, (boolean)keepLoaded);
        DimensionManager.registerDimension((int)dim, (DimensionType)deep_dank_dim);
        teleporter = new BlockTeleporterDeepDank();
        GameRegistry.register((IForgeRegistryEntry)teleporter.setRegistryName(new ResourceLocation(modid, "teleporterbeneath")));
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock(teleporter).setRegistryName(new ResourceLocation(modid, "teleporterbeneath")));
        GameRegistry.registerTileEntity(TileEntityTeleporterDeepDank.class, (String)"tileEntityTeleporterBeneath");
        beneath_normal = (SoundEvent)GameRegistry.register((IForgeRegistryEntry)new SoundEvent(new ResourceLocation(modid, "beneath.normal")).setRegistryName(new ResourceLocation(modid, "beneath.normal")));
        beneath_muffled = (SoundEvent)GameRegistry.register((IForgeRegistryEntry)new SoundEvent(new ResourceLocation(modid, "beneath.muffled")).setRegistryName(new ResourceLocation(modid, "beneath.muffled")));
        beneath_drawnout = (SoundEvent)GameRegistry.register((IForgeRegistryEntry)new SoundEvent(new ResourceLocation(modid, "beneath.drawnout")).setRegistryName(new ResourceLocation(modid, "beneath.drawnout")));
        deepdank = (SoundEvent)GameRegistry.register((IForgeRegistryEntry)new SoundEvent(new ResourceLocation(modid, "deepdank")).setRegistryName(new ResourceLocation(modid, "deepdank")));
        dark1 = (SoundEvent)GameRegistry.register((IForgeRegistryEntry)new SoundEvent(new ResourceLocation(modid, "dark1")).setRegistryName(new ResourceLocation(modid, "dark1")));
        dark2 = (SoundEvent)GameRegistry.register((IForgeRegistryEntry)new SoundEvent(new ResourceLocation(modid, "dark2")).setRegistryName(new ResourceLocation(modid, "dark2")));
        scream = (SoundEvent)GameRegistry.register((IForgeRegistryEntry)new SoundEvent(new ResourceLocation(modid, "scream")).setRegistryName(new ResourceLocation(modid, "scream")));
        Beneath.registerEntityWithEgg(EntityShadow.class, "shadow", 1, 80, 3, true, 0, 0);
        EntityRegistry.registerModEntity(EntityHand.class, (String)"hand", (int)2, (Object)instance, (int)80, (int)3, (boolean)true);
        if (mode.equalsIgnoreCase("grue")) {
            FMLInterModComms.sendMessage((String)"grue", (String)"registerDimensionWhitelistOverride", (String)String.valueOf(dim));
        }
        PacketDispatcher.registerPackets();
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (internalOreGen) {
            OreGenHandler.setupOregenFile();
            OreGenHandler.saveOregenFile();
        }
        if (useCraftingRecipe) {
            GameRegistry.addRecipe((IRecipe)this.createCraftingRecipe(craftingRecipe));
        }
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ((BiomeDeepDank)deep_dank).setSpawnLists();
        proxy.postInit();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals(modid)) {
            Beneath.syncConfig();
        }
    }

    private static void syncConfig() {
        dim = cfg.get("general", "Dimension ID", 10, "Dimension ID for The Beneath.").getInt();
        mode = cfg.get("general", "Mode", Loader.isModLoaded((String)"grue") ? "grue" : "darkness", "What mode The Beneath is set to. Current modes are:\ngrue: Grues spawn in the darkness\ndarkness: You take damage while in dark areas.\n" + TextFormatting.RED + "[Minecraft Restart Required]" + TextFormatting.RESET).getString();
        internalOreGen = cfg.get("general", "Internal Ore Generator", true, "Toggles whether or not to use the built-in Ore Generator. Can be disabled if you have another mod that handles Ore Generation.\n" + TextFormatting.RED + "[Minecraft Restart Required]" + TextFormatting.RESET).getBoolean();
        keepLoaded = cfg.get("general", "Keep Loaded", false, "Toggles whether or not The Beneath should be prevented from automatically unloading (might affect performance if enabled).\n" + TextFormatting.RED + "[Minecraft Restart Required]" + TextFormatting.RESET).getBoolean();
        dimTeleportation = cfg.get("general", "Additional Dimension Teleportation", false, "Toggles whether or not to allow teleporting back and forth between the Beneath and dimensions that aren't the Overworld").getBoolean();
        darkTimer = cfg.get("general", "Darkness damage timer", 5, "The amount of seconds before the darkness damages you (when the mode is set to darkness).\n[range: 1 ~ 10, default: 5]", 1, 10).getInt();
        darkDamage = cfg.get("general", "Darkness damage", 2, "The amount of damage (half hearts) you take from the darkness (when the mode is set to darkness).\n[range: 2 ~ 20, default: 2]", 2, 20).getInt();
        dungeonChance = cfg.get("general", "Dungeon spawn chance", 8, "The chance that a dungeon generates in The Beneath (same logic as the vanilla setting). Setting it to 0 stops dungeon generation.\n[range: 0 ~ 100, default: 8]", 0, 100).getInt();
        shadowSpawnWeight = cfg.get("general", "Shadow Spawn Weight", 50, "Spawn Weight for the shadows, increase to increase the chance of them spawning, or decrease to decrease the chance of them spawning.\n[range: 10 ~ 100, default: 50]", 10, 100).getInt();
        disableMobSpawning = cfg.get("general", "Disable Mob Spawning", false, "Toggles whether or not to stop mob spawning inside The Beneath.").getBoolean();
        useCraftingRecipe = cfg.get("general", "Use Crafting Recipe", false, "Toggles whether or not to use the configurable crafting recipe.\n" + TextFormatting.RED + "[Minecraft Restart Required]" + TextFormatting.RESET).getBoolean();
        craftingRecipe = cfg.get("general", "Beneath Teleporter Crafting Recipe", new String[]{"#&#", "&%&", "#&#", "#", "minecraft:stone:*", "&", "cobblestone", "%", "minecraft:nether_star"}, "Configurable crafting recipe for the Beneath Teleporter.\nThe first 3 Strings in the array are the recipe formula, where each symbol represents an Item. The Items are defined by the character being in the array before the Item in question (check the default).\nFormat for Items: modid:name:meta (where meta is optional, and * can be used to speficy the metadata wildcard). The OreDictionary can also be used, where you just specify the ore name (ingotIron for Iron Ingots, stone for Stone)\n" + TextFormatting.RED + "[Only used if Use Crafting Recipe is enabled]" + TextFormatting.RESET).getStringList();
        darkTimer = MathHelper.func_76125_a((int)darkTimer, (int)1, (int)10);
        darkDamage = MathHelper.func_76125_a((int)darkDamage, (int)2, (int)20);
        shadowSpawnWeight = MathHelper.func_76125_a((int)shadowSpawnWeight, (int)10, (int)100);
        if (mode.equalsIgnoreCase("grue") && !Loader.isModLoaded((String)"grue")) {
            mode = "darkness";
        }
        if (cfg.hasChanged()) {
            cfg.save();
        }
    }

    private static int getUniqueEntityId() {
        while (EntityList.field_75623_d.containsKey(++startEntityId)) {
        }
        return startEntityId;
    }

    private static void registerEntityWithEgg(Class<? extends Entity> entity, String name, int modid, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int primaryColor, int secondaryColor) {
        int id = Beneath.getUniqueEntityId();
        EntityRegistry.registerModEntity(entity, (String)name, (int)modid, (Object)instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates, (int)primaryColor, (int)secondaryColor);
        EntityList.field_75623_d.put(id, entity);
    }

    private ShapedOreRecipe createCraftingRecipe(String[] data) {
        Object[] recipe = new Object[data.length];
        recipe[0] = data[0];
        recipe[1] = data[1];
        recipe[2] = data[2];
        for (int i = 3; i < data.length; ++i) {
            recipe[i] = this.getObject(data[i]);
        }
        return new ShapedOreRecipe(teleporter, recipe);
    }

    private Object getObject(String data) {
        if (data.length() == 1) {
            return Character.valueOf(data.charAt(0));
        }
        if (data.lastIndexOf(":") == -1) {
            return data;
        }
        String[] stuff = data.split(":");
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(stuff[0], stuff[1]));
        if (item == null) {
            return null;
        }
        int meta = stuff.length == 3 ? (stuff[2].equals("*") ? Short.MAX_VALUE : Integer.valueOf(stuff[2])) : 0;
        return new ItemStack(item, 1, meta);
    }

    private String getSupporterList() {
        String names = "";
        try {
            BufferedReader nameFile = new BufferedReader(new InputStreamReader(new URL("https://raw.githubusercontent.com/Shinoow/AbyssalCraft/master/supporters.txt").openStream()));
            names = nameFile.readLine();
            nameFile.close();
        }
        catch (IOException e) {
            FMLLog.log((String)name, (Level)Level.ERROR, (String)"Failed to fetch supporter list, using local version!", (Object[])new Object[0]);
            names = "Enfalas, Saice Shoop, Minecreatr";
        }
        return names;
    }

    static {
        instance = new Beneath();
        startEntityId = 200;
        darkness = new DamageSource("darkness").func_76348_h();
    }
}

