/*
 * Decompiled with CFR 0.152.
 */
package com.setycz.chickens.jei.breeding;

import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class BreedingRecipeCategory
implements IRecipeCategory {
    public static final String UID = "chickens.Breeding";
    private final String title = Translator.translateToLocal((String)"gui.breeding");
    private final IDrawableStatic background;
    private final IDrawableAnimated arrow;
    private final IDrawableStatic icon;

    public BreedingRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("chickens", "textures/gui/breeding.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 82, 54);
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(location, 82, 0, 7, 7);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.BOTTOM, false);
        ResourceLocation iconLocation = new ResourceLocation("chickens", "textures/gui/breeding_icon.png");
        this.icon = guiHelper.createDrawable(iconLocation, 0, 0, 16, 16);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void drawExtras(Minecraft minecraft) {
        this.arrow.draw(minecraft, 37, 5);
    }

    @Deprecated
    public void drawAnimations(Minecraft minecraft) {
    }

    @Deprecated
    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper) {
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        int parent1Slot = 0;
        guiItemStacks.init(parent1Slot, true, 10, 15);
        guiItemStacks.set(ingredients);
        int parent2Slot = 1;
        guiItemStacks.init(parent2Slot, true, 53, 15);
        guiItemStacks.set(ingredients);
        int childrenSlot = 2;
        guiItemStacks.init(childrenSlot, false, 33, 30);
        guiItemStacks.set(ingredients);
    }
}

