/*
 * Decompiled with CFR 0.152.
 */
package com.setycz.chickens.henhouse;

import com.setycz.chickens.IInventoryGui;
import com.setycz.chickens.henhouse.ContainerHenhouse;
import com.setycz.chickens.henhouse.GuiHenhouse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityHenhouse
extends TileEntity
implements ISidedInventory,
IInventoryGui {
    public static final int hayBaleEnergy = 100;
    public static final int hayBaleSlotIndex = 0;
    public static final int dirtSlotIndex = 1;
    public static final int firstItemSlotIndex = 2;
    private static final int lastItemSlotIndex = 10;
    private static final double HENHOUSE_RADIUS = 0.5;
    private static final double FENCE_THRESHOLD = 0.5;
    private String customName;
    private final ItemStack[] slots = new ItemStack[11];
    private int energy = 0;

    @Nullable
    public static ItemStack pushItemStack(ItemStack itemToLay, World worldObj, Vec3d pos) {
        TileEntityHenhouse henhouse;
        List<TileEntityHenhouse> henhouses = TileEntityHenhouse.findHenhouses(worldObj, pos, 5.0);
        Iterator<TileEntityHenhouse> iterator = henhouses.iterator();
        while (iterator.hasNext() && (itemToLay = (henhouse = iterator.next()).pushItemStack(itemToLay)) != null) {
        }
        return itemToLay;
    }

    private static List<TileEntityHenhouse> findHenhouses(World worldObj, Vec3d pos, double radius) {
        int firstChunkX = MathHelper.func_76128_c((double)((pos.field_72450_a - radius - World.MAX_ENTITY_RADIUS) / 16.0));
        int lastChunkX = MathHelper.func_76128_c((double)((pos.field_72450_a + radius + World.MAX_ENTITY_RADIUS) / 16.0));
        int firstChunkY = MathHelper.func_76128_c((double)((pos.field_72449_c - radius - World.MAX_ENTITY_RADIUS) / 16.0));
        int lastChunkY = MathHelper.func_76128_c((double)((pos.field_72449_c + radius + World.MAX_ENTITY_RADIUS) / 16.0));
        ArrayList<Double> distances = new ArrayList<Double>();
        ArrayList<TileEntityHenhouse> result = new ArrayList<TileEntityHenhouse>();
        for (int chunkX = firstChunkX; chunkX <= lastChunkX; ++chunkX) {
            for (int chunkY = firstChunkY; chunkY <= lastChunkY; ++chunkY) {
                Chunk chunk = worldObj.func_72964_e(chunkX, chunkY);
                for (TileEntity tileEntity : chunk.func_177434_r().values()) {
                    Vec3d tileEntityPos;
                    boolean inRage;
                    if (!(tileEntity instanceof TileEntityHenhouse) || !(inRage = TileEntityHenhouse.testRange(pos, tileEntityPos = new Vec3d((Vec3i)tileEntity.func_174877_v()).func_72441_c(0.5, 0.5, 0.5), radius))) continue;
                    double distance = pos.func_72438_d(tileEntityPos);
                    TileEntityHenhouse.addHenhouseToResults((TileEntityHenhouse)tileEntity, distance, distances, result);
                }
            }
        }
        return result;
    }

    private static boolean testRange(Vec3d pos1, Vec3d pos2, double range) {
        return Math.abs(pos1.field_72450_a - pos2.field_72450_a) <= range && Math.abs(pos1.field_72448_b - pos2.field_72448_b) <= range && Math.abs(pos1.field_72449_c - pos2.field_72449_c) <= range;
    }

    private static void addHenhouseToResults(TileEntityHenhouse henhouse, double distance, List<Double> distances, List<TileEntityHenhouse> henhouses) {
        for (int resultIndex = 0; resultIndex < distances.size(); ++resultIndex) {
            if (!(distance < distances.get(resultIndex))) continue;
            distances.add(resultIndex, distance);
            henhouses.add(resultIndex, henhouse);
            return;
        }
        distances.add(distance);
        henhouses.add(henhouse);
    }

    @Nullable
    private ItemStack pushItemStack(ItemStack stack) {
        ItemStack rest = stack.func_77946_l();
        int capacity = this.getEffectiveCapacity();
        if (capacity <= 0) {
            return rest;
        }
        for (int slotIndex = 2; slotIndex <= 10; ++slotIndex) {
            int canAdd = this.canAdd(this.slots[slotIndex], rest);
            int willAdd = Math.min(canAdd, capacity);
            if (willAdd <= 0) continue;
            this.consumeEnergy(willAdd);
            capacity -= willAdd;
            if (this.slots[slotIndex] == null) {
                this.slots[slotIndex] = rest.func_77979_a(willAdd);
            } else {
                this.slots[slotIndex].field_77994_a += willAdd;
                rest.field_77994_a -= willAdd;
            }
            if (rest.field_77994_a > 0) continue;
            return null;
        }
        this.func_70296_d();
        return rest;
    }

    private void consumeEnergy(int amount) {
        while (amount > 0) {
            if (this.energy == 0) {
                assert (this.slots[0] != null);
                --this.slots[0].field_77994_a;
                if (this.slots[0].field_77994_a <= 0) {
                    this.slots[0] = null;
                }
                this.energy += 100;
            }
            int consumed = Math.min(amount, this.energy);
            this.energy -= consumed;
            amount -= consumed;
            if (this.energy > 0) continue;
            if (this.slots[1] == null) {
                this.slots[1] = new ItemStack(Blocks.field_150346_d, 1);
                continue;
            }
            ++this.slots[1].field_77994_a;
        }
    }

    private int canAdd(@Nullable ItemStack slotStack, ItemStack inputStack) {
        if (slotStack == null) {
            return Math.min(this.func_70297_j_(), inputStack.field_77994_a);
        }
        if (!slotStack.func_77969_a(inputStack)) {
            return 0;
        }
        if (slotStack.field_77994_a >= this.func_70297_j_()) {
            return 0;
        }
        return Math.min(inputStack.field_77994_a, this.func_70297_j_() - slotStack.field_77994_a);
    }

    private int getEffectiveCapacity() {
        return Math.min(this.getInputCapacity(), this.getOutputCapacity());
    }

    private int getInputCapacity() {
        int potential = this.energy;
        ItemStack hayBaleStack = this.slots[0];
        if (hayBaleStack != null && hayBaleStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150407_cf)) {
            potential += hayBaleStack.field_77994_a * 100;
        }
        return potential;
    }

    private int getOutputCapacity() {
        ItemStack dirtStack = this.slots[1];
        if (dirtStack == null) {
            return this.func_70297_j_() * 100;
        }
        if (dirtStack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150346_d)) {
            return 0;
        }
        return (this.func_70297_j_() - dirtStack.field_77994_a) * 100;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.func_145818_k_()) {
            compound.func_74778_a("customName", this.customName);
        }
        compound.func_74768_a("energy", this.energy);
        NBTTagList items = new NBTTagList();
        for (int slotIndex = 0; slotIndex < this.slots.length; ++slotIndex) {
            ItemStack itemStack = this.slots[slotIndex];
            if (itemStack == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74768_a("slot", slotIndex);
            itemStack.func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        compound.func_74782_a("items", (NBTBase)items);
        compound.func_74768_a("energy", this.energy);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.customName = compound.func_74779_i("customName");
        this.energy = compound.func_74762_e("energy");
        Arrays.fill(this.slots, null);
        NBTTagList items = compound.func_150295_c("items", 10);
        for (int itemIndex = 0; itemIndex < items.func_74745_c(); ++itemIndex) {
            ItemStack itemStack;
            NBTTagCompound item = items.func_150305_b(itemIndex);
            int slotIndex = item.func_74762_e("slot");
            this.slots[slotIndex] = itemStack = ItemStack.func_77949_a((NBTTagCompound)item);
        }
        this.energy = compound.func_74762_e("energy");
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.slots[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.slots[index];
        if (stack == null) {
            return null;
        }
        if (count >= stack.field_77994_a) {
            this.slots[index] = null;
            return stack;
        }
        return stack.func_77979_a(count);
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.slots[index];
        this.slots[index] = null;
        return stack;
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        this.slots[index] = stack;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150407_cf);
        }
        return index != 1;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.energy;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.energy = value;
            }
        }
    }

    public int func_174890_g() {
        return 1;
    }

    public void func_174888_l() {
        for (int slotIndex = 0; slotIndex < this.slots.length; ++slotIndex) {
            this.slots[slotIndex] = null;
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.henhouse";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    @Override
    public Container createContainer(InventoryPlayer inventoryplayer) {
        return new ContainerHenhouse(inventoryplayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer createGui(InventoryPlayer inventoryplayer) {
        return new GuiHenhouse(inventoryplayer, this);
    }

    public int getEnergy() {
        return this.energy;
    }

    public int[] func_180463_a(EnumFacing side) {
        switch (side) {
            case DOWN: {
                int itemSlotCount = 9;
                int[] itemSlots = new int[itemSlotCount + 1];
                itemSlots[0] = 1;
                for (int resultIndex = 0; resultIndex < itemSlotCount; ++resultIndex) {
                    itemSlots[resultIndex + 1] = 2 + resultIndex;
                }
                return itemSlots;
            }
            case UP: {
                return new int[]{0};
            }
        }
        return new int[0];
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }
}

