/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.resource;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import wanion.lib.common.MetaItem;
import wanion.unidict.UniDict;
import wanion.unidict.resource.Resource;
import wanion.unidict.resource.UniAttributes;
import wanion.unidict.resource.UniResourceContainer;

public final class ResourceHandler
implements UniDict.IDependency {
    static final Set<ItemStack> keepOneEntryBlackSet = new HashSet<ItemStack>();
    public final Collection<Resource> resources;
    private final TIntObjectMap<UniAttributes> individualStackAttributes = new TIntObjectHashMap();
    private final Map<String, UniResourceContainer> containerMap = new THashMap();
    private final Map<String, Resource> resourceMap;

    ResourceHandler(@Nonnull Map<String, Resource> resourceMap) {
        this.resourceMap = resourceMap;
        this.resources = this.resourceMap.values();
    }

    public static void addToKeepOneEntryModBlackSet(@Nonnull ItemStack itemStack) {
        keepOneEntryBlackSet.add(itemStack);
    }

    public boolean exists(int thingId) {
        return this.individualStackAttributes.containsKey(thingId);
    }

    public boolean exists(ItemStack thing) {
        return this.individualStackAttributes.containsKey(MetaItem.get((ItemStack)thing));
    }

    public boolean resourceExists(@Nonnull String name) {
        return this.resourceMap.containsKey(name);
    }

    private UniAttributes get(ItemStack thing) {
        return (UniAttributes)this.individualStackAttributes.get(MetaItem.get((ItemStack)thing));
    }

    public Resource getResource(String resourceName) {
        return this.resourceMap.get(resourceName);
    }

    public Resource getResource(ItemStack thing) {
        UniAttributes attributesOfThing = this.get(thing);
        return attributesOfThing != null ? attributesOfThing.resource : null;
    }

    public UniResourceContainer getContainer(String name) {
        return this.containerMap.get(name);
    }

    public UniResourceContainer getContainer(ItemStack thing) {
        UniAttributes attributesOfThing = this.get(thing);
        return attributesOfThing != null ? attributesOfThing.uniResourceContainer : null;
    }

    public String getContainerName(ItemStack thing) {
        UniAttributes attributesOfThing = this.get(thing);
        return attributesOfThing != null ? attributesOfThing.uniResourceContainer.name : null;
    }

    public ItemStack getMainItemStack(ItemStack thing) {
        UniAttributes attributesOfThing = this.get(thing);
        return attributesOfThing != null ? attributesOfThing.uniResourceContainer.getMainEntry(thing.field_77994_a) : thing;
    }

    public List<ItemStack> getMainItemStacks(@Nonnull Collection<ItemStack> things) {
        return things.stream().map(this::getMainItemStack).collect(Collectors.toList());
    }

    public void setMainItemStacks(@Nonnull List<ItemStack> thingList) {
        for (int i = 0; i < thingList.size(); ++i) {
            thingList.set(i, this.getMainItemStack(thingList.get(i)));
        }
    }

    public void setMainObjects(@Nonnull List<Object> thingList) {
        for (int i = 0; i < thingList.size(); ++i) {
            if (!(thingList.get(i) instanceof ItemStack)) continue;
            thingList.set(i, this.getMainItemStack((ItemStack)thingList.get(i)));
        }
    }

    public ItemStack[] getMainItemStacks(@Nonnull ItemStack[] things) {
        for (int i = 0; i < things.length; ++i) {
            things[i] = this.getMainItemStack(things[i]);
        }
        return things;
    }

    public void setMainItemStacks(@Nonnull Object[] things) {
        for (int i = 0; i < things.length; ++i) {
            if (!(things[i] instanceof ItemStack)) continue;
            things[i] = this.getMainItemStack((ItemStack)things[i]);
        }
    }

    public boolean containerExists(@Nonnull String name) {
        return this.containerMap.containsKey(name);
    }

    public List<Resource> getResources(int ... kinds) {
        return Resource.getResources(this.resources, kinds);
    }

    void populateIndividualStackAttributes() {
        this.resources.forEach(resource -> resource.getChildrenMap().forEachValue(container -> {
            this.containerMap.put(container.name, (UniResourceContainer)container);
            UniAttributes uniAttributes = new UniAttributes((Resource)resource, (UniResourceContainer)container);
            for (int hash : container.getHashes()) {
                this.individualStackAttributes.put(hash, (Object)uniAttributes);
            }
            return true;
        }));
    }
}

