/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.recipe;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.TIntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import wanion.lib.recipe.RecipeHelper;
import wanion.unidict.UniDict;
import wanion.unidict.common.Util;
import wanion.unidict.recipe.AbstractRecipeResearcher;

public class ForgeRecipeResearcher
extends AbstractRecipeResearcher<ShapedOreRecipe, ShapelessOreRecipe> {
    public int getShapedRecipeKey(@Nonnull ShapedOreRecipe recipe) {
        TIntList recipeKeys = Util.getList(recipe.getInput(), this.resourceHandler);
        int recipeKey = 0;
        recipeKeys.sort();
        TIntIterator recipeKeysIterator = recipeKeys.iterator();
        while (recipeKeysIterator.hasNext()) {
            recipeKey += 31 * recipeKeysIterator.next();
        }
        return recipeKey;
    }

    public int getShapelessRecipeKey(@Nonnull ShapelessOreRecipe recipe) {
        TIntList recipeKeys = Util.getList(recipe.getInput().toArray(), this.resourceHandler);
        int recipeKey = 0;
        recipeKeys.sort();
        TIntIterator recipeKeysIterator = recipeKeys.iterator();
        while (recipeKeysIterator.hasNext()) {
            recipeKey += 31 * recipeKeysIterator.next();
        }
        return recipeKey;
    }

    @Nonnull
    public List<Class<? extends ShapedOreRecipe>> getShapedRecipeClasses() {
        Class<?> shapedCustomRecipe = null;
        try {
            if (Loader.isModLoaded((String)"forestry")) {
                shapedCustomRecipe = Class.forName("forestry.core.recipes.ShapedRecipeCustom");
            }
        }
        catch (ClassNotFoundException e) {
            UniDict.getLogger().error((Object)e);
        }
        return shapedCustomRecipe == null ? Collections.singletonList(ShapedOreRecipe.class) : Arrays.asList(ShapedOreRecipe.class, shapedCustomRecipe);
    }

    @Nonnull
    public List<Class<? extends ShapelessOreRecipe>> getShapelessRecipeClasses() {
        return Collections.singletonList(ShapelessOreRecipe.class);
    }

    public ShapedOreRecipe getNewShapedRecipe(@Nonnull ShapedOreRecipe recipe) {
        Object[] recipeInputs = recipe.getInput();
        Object[] newRecipeInputs = new Object[9];
        if (itemStacksOnly) {
            for (int i = 0; i < 9; ++i) {
                Object input;
                Object object = input = i < recipeInputs.length ? recipeInputs[i] : null;
                newRecipeInputs[i] = input instanceof List && !((List)input).isEmpty() ? (ItemStack)((List)input).get(0) : (input instanceof ItemStack ? this.resourceHandler.getMainItemStack((ItemStack)input) : null);
            }
        } else {
            for (int i = 0; i < 9; ++i) {
                String bufferOreName;
                Object input;
                Object object = input = i < recipeInputs.length ? recipeInputs[i] : null;
                String string = input != null ? (input instanceof List ? this.uniOreDictionary.getName(input) : (input instanceof ItemStack ? this.resourceHandler.getContainerName((ItemStack)input) : null)) : (bufferOreName = null);
                newRecipeInputs[i] = input != null ? (bufferOreName != null ? bufferOreName : input) : null;
            }
        }
        return new ShapedOreRecipe(this.resourceHandler.getMainItemStack(recipe.func_77571_b()), RecipeHelper.rawShapeToShape((Object[])newRecipeInputs));
    }

    public ShapedOreRecipe getNewShapedFromShapelessRecipe(@Nonnull ShapelessOreRecipe recipe) {
        Object[] recipeInputs = recipe.getInput().toArray();
        Object[] newRecipeInputs = new Object[recipeInputs.length];
        if (itemStacksOnly) {
            for (int i = 0; i < recipeInputs.length; ++i) {
                Object input;
                Object object = input = i < recipeInputs.length ? recipeInputs[i] : null;
                newRecipeInputs[i] = input instanceof List && !((List)input).isEmpty() ? (ItemStack)((List)input).get(0) : (input instanceof ItemStack ? this.resourceHandler.getMainItemStack((ItemStack)input) : null);
            }
        } else {
            for (int i = 0; i < recipeInputs.length; ++i) {
                String bufferOreName;
                Object input;
                Object object = input = i < recipeInputs.length ? recipeInputs[i] : null;
                String string = input != null ? (input instanceof List ? this.uniOreDictionary.getName(input) : (input instanceof ItemStack ? this.resourceHandler.getContainerName((ItemStack)input) : null)) : (bufferOreName = null);
                newRecipeInputs[i] = input != null ? (bufferOreName != null ? bufferOreName : input) : null;
            }
        }
        return new ShapedOreRecipe(this.resourceHandler.getMainItemStack(recipe.func_77571_b()), RecipeHelper.rawShapeToShape((Object[])newRecipeInputs));
    }

    public ShapelessOreRecipe getNewShapelessRecipe(@Nonnull ShapelessOreRecipe recipe) {
        ArrayList inputs = new ArrayList();
        if (itemStacksOnly) {
            recipe.getInput().forEach(object -> {
                if (object != null) {
                    if (object instanceof List && !((List)object).isEmpty()) {
                        inputs.add(((List)object).get(0));
                    } else if (object instanceof ItemStack) {
                        inputs.add(this.resourceHandler.getMainItemStack((ItemStack)object));
                    }
                }
            });
        } else {
            recipe.getInput().forEach(object -> {
                if (object != null) {
                    String bufferOreName;
                    String string = object instanceof List ? this.uniOreDictionary.getName(object) : (bufferOreName = object instanceof ItemStack ? this.resourceHandler.getContainerName((ItemStack)object) : null);
                    if (bufferOreName != null) {
                        inputs.add(bufferOreName);
                    } else if (object instanceof ItemStack) {
                        inputs.add(object);
                    }
                }
            });
        }
        return new ShapelessOreRecipe(this.resourceHandler.getMainItemStack(recipe.func_77571_b()), inputs.toArray());
    }

    public ShapelessOreRecipe getNewShapelessFromShapedRecipe(@Nonnull ShapedOreRecipe recipe) {
        ArrayList<Object> inputs = new ArrayList<Object>();
        if (itemStacksOnly) {
            for (Object object : recipe.getInput()) {
                if (object == null) continue;
                if (object instanceof List && !((List)object).isEmpty()) {
                    inputs.add(((List)object).get(0));
                    continue;
                }
                if (!(object instanceof ItemStack)) continue;
                inputs.add(this.resourceHandler.getMainItemStack((ItemStack)object));
            }
        } else {
            for (Object object : recipe.getInput()) {
                String bufferOreName;
                if (object == null) continue;
                String string = object instanceof List ? this.uniOreDictionary.getName(object) : (bufferOreName = object instanceof ItemStack ? this.resourceHandler.getContainerName((ItemStack)object) : null);
                if (bufferOreName != null) {
                    inputs.add(bufferOreName);
                    continue;
                }
                if (!(object instanceof ItemStack)) continue;
                inputs.add(object);
            }
        }
        return new ShapelessOreRecipe(this.resourceHandler.getMainItemStack(recipe.func_77571_b()), inputs.toArray());
    }
}

