/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import com.google.common.collect.Lists;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.Loader;
import wanion.lib.recipe.IRecipeResearcher;
import wanion.unidict.UniDict;
import wanion.unidict.integration.AbstractIntegrationThread;
import wanion.unidict.recipe.AbstractRecipeResearcher;
import wanion.unidict.recipe.ForgeRecipeResearcher;
import wanion.unidict.recipe.IC2RecipeResearcher;
import wanion.unidict.recipe.VanillaRecipeResearcher;
import wanion.unidict.resource.UniResourceContainer;

final class CraftingIntegration
extends AbstractIntegrationThread {
    private final List<IRecipe> recipes = CraftingManager.func_77594_a().func_77592_b();
    private final Map<Class<? extends IRecipe>, IRecipeResearcher<? extends IRecipe, ? extends IRecipe>> shapedResearcherMap = new IdentityHashMap<Class<? extends IRecipe>, IRecipeResearcher<? extends IRecipe, ? extends IRecipe>>();
    private final Map<Class<? extends IRecipe>, IRecipeResearcher<? extends IRecipe, ? extends IRecipe>> shapelessResearcherMap = new IdentityHashMap<Class<? extends IRecipe>, IRecipeResearcher<? extends IRecipe, ? extends IRecipe>>();
    private final Map<UniResourceContainer, TIntObjectMap<List<IRecipe>>> smartRecipeMap = new IdentityHashMap<UniResourceContainer, TIntObjectMap<List<IRecipe>>>();
    private final Method getShapedRecipeKeyMethod;
    private final Method getShapelessRecipeKeyMethod;
    private final Method getNewShapedRecipeMethod;
    private final Method getNewShapedFromShapelessRecipeMethod;
    private final Method getNewShapelessRecipeMethod;
    private final Method getNewShapelessFromShapedRecipeMethod;
    private int totalRecipesReCreated = 0;

    CraftingIntegration() {
        super("Crafting");
        ArrayList<AbstractRecipeResearcher> researcherList = new ArrayList<AbstractRecipeResearcher>();
        researcherList.add(new VanillaRecipeResearcher());
        researcherList.add(new ForgeRecipeResearcher());
        if (Loader.isModLoaded((String)"IC2") && !Loader.isModLoaded((String)"IC2-Classic-Spmod")) {
            researcherList.add(new IC2RecipeResearcher());
        }
        researcherList.forEach(researcher -> {
            researcher.getShapedRecipeClasses().forEach(shapedRecipeClass -> this.shapedResearcherMap.put((Class<? extends IRecipe>)shapedRecipeClass, (IRecipeResearcher<? extends IRecipe, ? extends IRecipe>)researcher));
            researcher.getShapelessRecipeClasses().forEach(shapelessRecipeClass -> this.shapelessResearcherMap.put((Class<? extends IRecipe>)shapelessRecipeClass, (IRecipeResearcher<? extends IRecipe, ? extends IRecipe>)researcher));
        });
        try {
            this.getShapedRecipeKeyMethod = IRecipeResearcher.class.getMethod("getShapedRecipeKey", IRecipe.class);
            this.getShapelessRecipeKeyMethod = IRecipeResearcher.class.getMethod("getShapelessRecipeKey", IRecipe.class);
            this.getNewShapedRecipeMethod = IRecipeResearcher.class.getMethod("getNewShapedRecipe", IRecipe.class);
            this.getNewShapedFromShapelessRecipeMethod = IRecipeResearcher.class.getMethod("getNewShapedFromShapelessRecipe", IRecipe.class);
            this.getNewShapelessRecipeMethod = IRecipeResearcher.class.getMethod("getNewShapelessRecipe", IRecipe.class);
            this.getNewShapelessFromShapedRecipeMethod = IRecipeResearcher.class.getMethod("getNewShapelessFromShapedRecipe", IRecipe.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Couldn't find the Methods!");
        }
    }

    public String call() {
        try {
            this.doTheResearch();
            this.reCreateTheRecipes();
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
        }
        return this.threadName + "Why so many recipes? I had to deal with " + this.totalRecipesReCreated + " recipes.";
    }

    private void doTheResearch() {
        Iterator<IRecipe> recipeIterator = this.recipes.iterator();
        while (recipeIterator.hasNext()) {
            UniResourceContainer bufferContainer;
            boolean isShapeless = false;
            IRecipe bufferRecipe = recipeIterator.next();
            if (bufferRecipe == null || (bufferContainer = this.resourceHandler.getContainer(bufferRecipe.func_77571_b())) == null || !this.shapedResearcherMap.containsKey(bufferRecipe.getClass()) && !(isShapeless = this.shapelessResearcherMap.containsKey(bufferRecipe.getClass()))) continue;
            try {
                TIntObjectHashMap evenSmarterRecipeMap;
                int recipeKey = !isShapeless ? ((Integer)this.getShapedRecipeKeyMethod.invoke(this.shapedResearcherMap.get(bufferRecipe.getClass()), bufferRecipe)).intValue() : ((Integer)this.getShapelessRecipeKeyMethod.invoke(this.shapelessResearcherMap.get(bufferRecipe.getClass()), bufferRecipe)).intValue();
                if (recipeKey == 0) continue;
                if (!this.smartRecipeMap.containsKey(bufferContainer)) {
                    evenSmarterRecipeMap = new TIntObjectHashMap();
                    this.smartRecipeMap.put(bufferContainer, (TIntObjectMap<List<IRecipe>>)evenSmarterRecipeMap);
                } else {
                    evenSmarterRecipeMap = this.smartRecipeMap.get(bufferContainer);
                }
                if (!evenSmarterRecipeMap.containsKey(recipeKey)) {
                    evenSmarterRecipeMap.put(recipeKey, (Object)Lists.newArrayList((Object[])new IRecipe[]{bufferRecipe}));
                } else {
                    ((List)evenSmarterRecipeMap.get(recipeKey)).add(bufferRecipe);
                }
                recipeIterator.remove();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void reCreateTheRecipes() {
        HashMap comparatorCache = new HashMap();
        this.smartRecipeMap.forEach((container, evenSmartRecipeMap) -> evenSmartRecipeMap.forEachValue(recipeList -> {
            block8: {
                IRecipe recipe;
                boolean isShapeless;
                if (recipeList.size() > 1) {
                    Comparator<IRecipe> recipeComparator;
                    boolean hasComparator = comparatorCache.containsKey(container);
                    Comparator<IRecipe> comparator = recipeComparator = hasComparator ? (Comparator)comparatorCache.get(container) : new RecipeComparator(container.getComparator());
                    if (!hasComparator) {
                        comparatorCache.put(container, recipeComparator);
                    }
                    recipeList.sort(recipeComparator);
                }
                IRecipeResearcher<? extends IRecipe, ? extends IRecipe> recipeResearcher = !(isShapeless = this.shapelessResearcherMap.containsKey((recipe = (IRecipe)recipeList.get(0)).getClass())) ? this.shapedResearcherMap.get(recipe.getClass()) : this.shapelessResearcherMap.get(recipe.getClass());
                try {
                    if (recipe.func_77570_a() == 9) {
                        this.recipes.add(isShapeless ? (IRecipe)this.getNewShapedFromShapelessRecipeMethod.invoke(recipeResearcher, recipe) : (IRecipe)this.getNewShapedRecipeMethod.invoke(recipeResearcher, recipe));
                    } else if (recipe.func_77570_a() == 1) {
                        this.recipes.add(isShapeless ? (IRecipe)this.getNewShapelessRecipeMethod.invoke(recipeResearcher, recipe) : (IRecipe)this.getNewShapelessFromShapedRecipeMethod.invoke(recipeResearcher, recipe));
                    } else {
                        this.recipes.add(isShapeless ? (IRecipe)this.getNewShapelessRecipeMethod.invoke(recipeResearcher, recipe) : (IRecipe)this.getNewShapedRecipeMethod.invoke(recipeResearcher, recipe));
                    }
                    ++this.totalRecipesReCreated;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    ItemStack outputStack = recipe.func_77571_b();
                    if (outputStack == null) break block8;
                    UniDict.getLogger().warn("Crafting Integration: Couldn't create the recipe for " + outputStack.func_82833_r() + ".\nre-adding the original recipe.");
                    this.recipes.add(recipe);
                }
            }
            return true;
        }));
    }

    private static class RecipeComparator
    implements Comparator<IRecipe> {
        private final Comparator<ItemStack> itemStackComparator;

        private RecipeComparator(@Nonnull Comparator<ItemStack> itemStackComparator) {
            this.itemStackComparator = itemStackComparator;
        }

        @Override
        public int compare(IRecipe o1, IRecipe o2) {
            return this.itemStackComparator.compare(o1.func_77571_b(), o2.func_77571_b());
        }
    }
}

