/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.items;

import ganymedes01.headcrumbs.items.FixedItemBlock;
import ganymedes01.headcrumbs.libs.SkullTypes;
import ganymedes01.headcrumbs.tileentities.TileEntityBlockSkull;
import ganymedes01.headcrumbs.utils.HeadUtils;
import ganymedes01.headcrumbs.utils.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ItemHeadcrumbsSkull
extends FixedItemBlock {
    public ItemHeadcrumbsSkull(Block block) {
        super(block);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (side == EnumFacing.DOWN) {
            return false;
        }
        BlockPos clickedPos = pos.func_177972_a(side.func_176734_d());
        IBlockState clickedState = world.func_180495_p(clickedPos);
        if (!clickedState.func_185904_a().func_76220_a() || !world.isSideSolid(clickedPos, side, true)) {
            return false;
        }
        if (!player.func_175151_a(pos, side, stack)) {
            return false;
        }
        if (!this.field_150939_a.func_176196_c(world, pos)) {
            return false;
        }
        if (!world.field_72995_K) {
            if (!this.field_150939_a.func_176198_a(world, pos, side)) {
                return false;
            }
            world.func_180501_a(pos, this.field_150939_a.func_176223_P().func_177226_a((IProperty)BlockSkull.field_176418_a, (Comparable)side), 3);
            TileEntity tile = world.func_175625_s(pos);
            this.populateTile(stack, side, player, tile);
        }
        return true;
    }

    protected void populateTile(ItemStack stack, EnumFacing side, EntityPlayer player, TileEntity tile) {
        if (tile instanceof TileEntityBlockSkull) {
            TileEntityBlockSkull tileSkull = (TileEntityBlockSkull)tile;
            SkullTypes model = HeadUtils.getModel(stack);
            tileSkull.func_152107_a(stack.func_77960_j());
            tileSkull.setSkullModel(model);
            int rotation = 0;
            if (side == EnumFacing.UP) {
                rotation = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF;
            }
            tileSkull.func_145903_a(rotation);
        }
    }

    public String func_77667_c(ItemStack stack) {
        SkullTypes type = HeadUtils.getModel(stack);
        return "item." + Utils.getUnlocalisedName(type.name());
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        return armorType == EntityEquipmentSlot.HEAD;
    }
}

