/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.configs;

import ganymedes01.headcrumbs.Headcrumbs;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    public static ConfigHandler INSTANCE = new ConfigHandler();
    public Configuration configFile;
    public String[] usedCategories = new String[]{"general", "heads", "mob"};

    public void init(File file) {
        this.configFile = new Configuration(file);
        this.syncConfigs();
    }

    private void syncConfigs() {
        Headcrumbs.addPlayerHeadsAsDungeonLoot = this.configFile.get("general", "Add player heads as dungeon loot", Headcrumbs.addPlayerHeadsAsDungeonLoot).setRequiresMcRestart(false).getBoolean();
        Headcrumbs.headsDungeonLootWeight = this.configFile.get("general", "Player heads loot weight", Headcrumbs.headsDungeonLootWeight, "The bigger this number the easier it will be to find heads in dungeons.\nSome heads will be rarer than others.\nExamples: Diamond is 1, Redstone is 10").setRequiresMcRestart(true).getInt();
        Headcrumbs.enablePlayerStatues = this.configFile.get("general", "Enable player statues", Headcrumbs.enablePlayerStatues, "Setting this to true allow statues to be built (Turning this off won't destroy existing statues)").setRequiresMcRestart(false).getBoolean();
        Headcrumbs.enableTooltips = this.configFile.get("general", "Enable head item tooltips", Headcrumbs.enableTooltips, "Enables tooltips with informations about certain names (mod authors mostly)").setRequiresMcRestart(false).getBoolean();
        Headcrumbs.others = this.configFile.get("heads", "others", Headcrumbs.others).setRequiresMcRestart(true).getStringList();
        Headcrumbs.modders = this.configFile.get("heads", "modders", Headcrumbs.modders).setRequiresMcRestart(true).getStringList();
        Headcrumbs.youtubers = this.configFile.get("heads", "youtubers", Headcrumbs.youtubers).setRequiresMcRestart(true).getStringList();
        Headcrumbs.mojang = this.configFile.get("heads", "mojang", Headcrumbs.mojang).setRequiresMcRestart(true).getStringList();
        Headcrumbs.mindCrack = this.configFile.get("heads", "mindCrack", Headcrumbs.mindCrack).setRequiresMcRestart(true).getStringList();
        Headcrumbs.hermitcraft = this.configFile.get("heads", "hermitcraft", Headcrumbs.hermitcraft).setRequiresMcRestart(true).getStringList();
        Headcrumbs.forgeCraft = this.configFile.get("heads", "forgeCraft", Headcrumbs.forgeCraft).setRequiresMcRestart(true).getStringList();
        Headcrumbs.ftb = this.configFile.get("heads", "ftb", Headcrumbs.ftb).setRequiresMcRestart(true).getStringList();
        Headcrumbs.technic = this.configFile.get("heads", "technic", Headcrumbs.technic).setRequiresMcRestart(true).getStringList();
        Headcrumbs.enableModSent = this.configFile.get("heads", "Enable usernames sent by other mods", Headcrumbs.enableModSent, "Other mods can add usernames using inter-mod communications, turns this config to false will prevent that from happening").setRequiresMcRestart(true).getBoolean();
        Headcrumbs.enableHumanMobs = this.configFile.get("mob", "Enable celebrity mobs", Headcrumbs.enableHumanMobs).setRequiresMcRestart(true).getBoolean();
        Headcrumbs.enableVIPs = this.configFile.get("mob", "Enable VIP drops", Headcrumbs.enableVIPs, "Setting this to false will disable special drops/weapons for certain celebrities. Existing mobs will still hold the weapons they spawned with.").setRequiresMcRestart(true).getBoolean();
        Headcrumbs.celebrityProb = this.configFile.get("mob", "Spawn probability", Headcrumbs.celebrityProb, "The change the mob will spawn. Base values: zombies, skeletons, spider, creepers = 100, endermen = 10, witches = 5").setRequiresMcRestart(true).getInt();
        Headcrumbs.celebrityMin = this.configFile.get("mob", "Minimum group size", Headcrumbs.celebrityMin, "The minimum size of the group of mobs that will spawn at once").setRequiresMcRestart(true).getInt();
        Headcrumbs.celebrityMax = this.configFile.get("mob", "Maximum group size", Headcrumbs.celebrityMax, "The maximum size of the group of mobs that will spawn at once").setRequiresMcRestart(true).getInt();
        Headcrumbs.blacklistedDimensions = this.configFile.get("mob", "Dimension Blacklist", Headcrumbs.blacklistedDimensions).getIntList();
        Headcrumbs.humanNamePrefix = this.configFile.get("mob", "prefix", Headcrumbs.humanNamePrefix, "This prefix will be shown in front of celebrities names in-world. Meant to be used to differentiate celebrities from real players.").getString();
        Headcrumbs.babyHumanChance = this.configFile.get("mob", "Baby human chance", Headcrumbs.babyHumanChance, "Chance that a human mob will spawn as a baby. Set to -1 to disable.").setRequiresMcRestart(false).getDouble(Headcrumbs.babyHumanChance);
        Headcrumbs.humansAttackTwins = this.configFile.get("mob", "Humans attack twins", Headcrumbs.humansAttackTwins, "Setting this to false will force humans to not attack players with the same name as themselves").setRequiresMcRestart(true).getBoolean();
        if (this.configFile.hasChanged()) {
            this.configFile.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if ("headcrumbs".equals(eventArgs.getModID())) {
            this.syncConfigs();
        }
    }
}

