/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.tile;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import javax.annotation.Nullable;
import net.blay09.mods.excompressum.block.BlockBait;
import net.blay09.mods.excompressum.block.ModBlocks;
import net.blay09.mods.excompressum.config.BaitConfig;
import net.blay09.mods.excompressum.registry.ExNihiloProvider;
import net.blay09.mods.excompressum.registry.ExRegistro;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.passive.HorseType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TileBait
extends TileEntity
implements ITickable {
    private static final int ENVIRONMENTAL_CHECK_INTERVAL = 200;
    private static final int MAX_BAITS_IN_AREA = 2;
    private static final int MIN_ENV_IN_AREA = 10;
    private static final int MAX_ANIMALS_IN_AREA = 2;
    private static final int SPAWN_CHECK_INTERVAL = 20;
    private static final int MIN_DISTANCE_NO_PLAYERS = 6;
    private static final Multimap<BlockBait.Type, BaitBlockCondition> envBlockMap = ArrayListMultimap.create();
    private ItemStack renderItemMain;
    private ItemStack renderItemSub;
    private EnvironmentalCondition environmentStatus;
    private int ticksSinceEnvironmentalCheck;
    private int ticksSinceSpawnCheck;

    public void func_73660_a() {
        if (this.renderItemMain == null) {
            this.renderItemMain = TileBait.getBaitDisplayItem(this.func_145832_p(), 0);
        }
        if (this.renderItemSub == null) {
            this.renderItemSub = TileBait.getBaitDisplayItem(this.func_145832_p(), 1);
        }
        ++this.ticksSinceEnvironmentalCheck;
        ++this.ticksSinceSpawnCheck;
        if (this.ticksSinceSpawnCheck >= 20) {
            int metadata = this.func_145832_p();
            if (!this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextFloat() <= this.getBaitChance(metadata) && this.checkSpawnConditions(true) == EnvironmentalCondition.CanSpawn) {
                float range = 6.0f;
                if (this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)this.field_174879_c.func_177958_n() - 6.0f), (double)((float)this.field_174879_c.func_177956_o() - 6.0f), (double)((float)this.field_174879_c.func_177952_p() - 6.0f), (double)((float)this.field_174879_c.func_177958_n() + 6.0f), (double)((float)this.field_174879_c.func_177956_o() + 6.0f), (double)((float)this.field_174879_c.func_177952_p() + 6.0f))).isEmpty()) {
                    EntityLiving entityLiving = TileBait.getBaitEntityLiving(this.field_145850_b, metadata);
                    if (entityLiving != null) {
                        if (entityLiving instanceof EntityAgeable && this.field_145850_b.field_73012_v.nextFloat() <= BaitConfig.baitChildChance) {
                            ((EntityAgeable)entityLiving).func_70873_a(-24000);
                        }
                        entityLiving.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
                        this.field_145850_b.func_72838_d((Entity)entityLiving);
                        ((WorldServer)this.field_145850_b).func_180505_a(EnumParticleTypes.EXPLOSION_LARGE, false, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 1, 0.0, 0.0, 0.0, 0.0, new int[0]);
                        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187665_Y, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                    this.field_145850_b.func_175698_g(this.field_174879_c);
                }
            }
            this.ticksSinceSpawnCheck = 0;
        }
    }

    @Nullable
    private static ItemStack getBaitDisplayItem(int metadata, int i) {
        BlockBait.Type type = BlockBait.Type.fromId(metadata);
        if (type != null) {
            switch (type) {
                case WOLF: {
                    return i == 0 ? new ItemStack(Items.field_151082_bd) : new ItemStack(Items.field_151103_aS);
                }
                case OCELOT: {
                    return i == 0 ? new ItemStack(Items.field_151016_H) : new ItemStack(Items.field_151115_aP);
                }
                case COW: {
                    return new ItemStack(Items.field_151015_O);
                }
                case PIG: {
                    return new ItemStack(Items.field_151172_bF);
                }
                case CHICKEN: {
                    return new ItemStack(Items.field_151014_N);
                }
                case SHEEP: {
                    ItemStack grassSeeds = ExRegistro.getNihiloItem(ExNihiloProvider.NihiloItems.SEEDS_GRASS);
                    if (grassSeeds != null) {
                        return i == 0 ? grassSeeds : new ItemStack(Items.field_151015_O);
                    }
                    return new ItemStack(Items.field_151015_O);
                }
                case SQUID: {
                    return new ItemStack(Items.field_151115_aP);
                }
                case RABBIT: {
                    return i == 0 ? new ItemStack(Items.field_151172_bF) : new ItemStack(Items.field_151081_bc);
                }
                case HORSE: {
                    return new ItemStack(Items.field_151153_ao);
                }
                case DONKEY: {
                    return new ItemStack(Items.field_151150_bK);
                }
            }
        }
        return null;
    }

    @Nullable
    private static EntityLiving getBaitEntityLiving(World world, int metadata) {
        BlockBait.Type type = BlockBait.Type.fromId(metadata);
        if (type != null) {
            switch (type) {
                case WOLF: {
                    return new EntityWolf(world);
                }
                case OCELOT: {
                    return new EntityOcelot(world);
                }
                case COW: {
                    return new EntityCow(world);
                }
                case PIG: {
                    return new EntityPig(world);
                }
                case CHICKEN: {
                    return new EntityChicken(world);
                }
                case SHEEP: {
                    return new EntitySheep(world);
                }
                case SQUID: {
                    return new EntitySquid(world);
                }
                case RABBIT: {
                    return new EntityRabbit(world);
                }
                case HORSE: {
                    return new EntityHorse(world);
                }
                case DONKEY: {
                    EntityHorse entity = new EntityHorse(world);
                    entity.func_184778_a(HorseType.DONKEY);
                    return entity;
                }
            }
        }
        return null;
    }

    private float getBaitChance(int metadata) {
        BlockBait.Type type = BlockBait.Type.fromId(metadata);
        if (type != null) {
            switch (type) {
                case WOLF: {
                    return BaitConfig.baitWolfChance;
                }
                case OCELOT: {
                    return BaitConfig.baitOcelotChance;
                }
                case COW: {
                    return BaitConfig.baitCowChance;
                }
                case PIG: {
                    return BaitConfig.baitPigChance;
                }
                case CHICKEN: {
                    return BaitConfig.baitChickenChance;
                }
                case SHEEP: {
                    return BaitConfig.baitSheepChance;
                }
                case SQUID: {
                    return BaitConfig.baitSquidChance;
                }
                case RABBIT: {
                    return BaitConfig.baitRabbitChance;
                }
                case HORSE: {
                    return BaitConfig.baitHorseChance;
                }
                case DONKEY: {
                    return BaitConfig.baitDonkeyChance;
                }
            }
        }
        return 0.0f;
    }

    @Nullable
    public ItemStack getRenderItem(int i) {
        return i == 0 ? this.renderItemMain : this.renderItemSub;
    }

    public EnvironmentalCondition checkSpawnConditions(boolean checkNow) {
        if (checkNow || this.ticksSinceEnvironmentalCheck > 200) {
            int metadata = this.func_145832_p();
            TileBait.populateEnvBlocks();
            Collection envBlocks = envBlockMap.get((Object)BlockBait.Type.fromId(metadata));
            if (envBlocks == null) {
                return EnvironmentalCondition.WrongEnv;
            }
            int range = 5;
            int rangeVertical = 3;
            int countBait = 0;
            int countEnvBlocks = 0;
            boolean foundWater = false;
            for (int x = this.field_174879_c.func_177958_n() - 5; x < this.field_174879_c.func_177958_n() + 5; ++x) {
                for (int y = this.field_174879_c.func_177956_o() - 3; y < this.field_174879_c.func_177956_o() + 3; ++y) {
                    for (int z = this.field_174879_c.func_177952_p() - 5; z < this.field_174879_c.func_177952_p() + 5; ++z) {
                        BlockPos testPos = new BlockPos(x, y, z);
                        IBlockState state = this.field_145850_b.func_180495_p(testPos);
                        if (state.func_177230_c() == ModBlocks.bait) {
                            ++countBait;
                        } else if (state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150358_i) {
                            foundWater = true;
                        }
                        for (BaitBlockCondition envBlock : envBlocks) {
                            int envMeta;
                            int meta;
                            if (state.func_177230_c() != envBlock.getState().func_177230_c() || !envBlock.isWildcard() && (meta = state.func_177230_c().func_176201_c(state)) != (envMeta = envBlock.getState().func_177230_c().func_176201_c(envBlock.getState()))) continue;
                            ++countEnvBlocks;
                        }
                    }
                }
            }
            this.environmentStatus = !foundWater ? EnvironmentalCondition.NoWater : (countBait > 2 ? EnvironmentalCondition.NearbyBait : (countEnvBlocks < 10 ? EnvironmentalCondition.WrongEnv : (this.field_145850_b.func_72872_a(EntityAnimal.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 10), (double)(this.field_174879_c.func_177956_o() - 3), (double)(this.field_174879_c.func_177952_p() - 10), (double)(this.field_174879_c.func_177958_n() + 10), (double)(this.field_174879_c.func_177956_o() + 3), (double)(this.field_174879_c.func_177952_p() + 10))).size() > 2 ? EnvironmentalCondition.NearbyAnimal : EnvironmentalCondition.CanSpawn)));
            this.ticksSinceEnvironmentalCheck = 0;
        }
        return this.environmentStatus;
    }

    private static void populateEnvBlocks() {
        if (envBlockMap.size() > 0) {
            return;
        }
        BlockBait.Type[] simpleTypes = new BlockBait.Type[]{BlockBait.Type.WOLF, BlockBait.Type.COW, BlockBait.Type.PIG, BlockBait.Type.CHICKEN, BlockBait.Type.SHEEP, BlockBait.Type.RABBIT, BlockBait.Type.HORSE, BlockBait.Type.DONKEY};
        BlockPlanks.EnumType[] acceptedTrees = new BlockPlanks.EnumType[]{BlockPlanks.EnumType.OAK, BlockPlanks.EnumType.BIRCH, BlockPlanks.EnumType.SPRUCE, BlockPlanks.EnumType.ACACIA, BlockPlanks.EnumType.DARK_OAK};
        for (BlockBait.Type type : simpleTypes) {
            envBlockMap.put((Object)type, (Object)new BaitBlockCondition(Blocks.field_150349_c.func_176223_P(), false));
            for (BlockPlanks.EnumType treeType : acceptedTrees) {
                envBlockMap.put((Object)type, (Object)new BaitBlockCondition(Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)treeType), false));
                if (BlockOldLog.field_176301_b.func_177700_c().contains(treeType)) {
                    envBlockMap.put((Object)type, (Object)new BaitBlockCondition(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)treeType), false));
                }
                if (!BlockNewLog.field_176300_b.func_177700_c().contains(treeType)) continue;
                envBlockMap.put((Object)type, (Object)new BaitBlockCondition(Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)treeType), false));
            }
            envBlockMap.put((Object)type, (Object)new BaitBlockCondition(Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS), false));
            envBlockMap.put((Object)type, (Object)new BaitBlockCondition(Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.FERN), false));
        }
        envBlockMap.put((Object)BlockBait.Type.OCELOT, (Object)new BaitBlockCondition(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE), false));
        envBlockMap.put((Object)BlockBait.Type.OCELOT, (Object)new BaitBlockCondition(Blocks.field_150395_bd.func_176223_P(), true));
        envBlockMap.put((Object)BlockBait.Type.OCELOT, (Object)new BaitBlockCondition(Blocks.field_150392_bi.func_176223_P(), false));
        envBlockMap.put((Object)BlockBait.Type.OCELOT, (Object)new BaitBlockCondition(Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.JUNGLE), false));
        envBlockMap.put((Object)BlockBait.Type.SQUID, (Object)new BaitBlockCondition(Blocks.field_150355_j.func_176223_P(), true));
        envBlockMap.put((Object)BlockBait.Type.SQUID, (Object)new BaitBlockCondition(Blocks.field_150358_i.func_176223_P(), true));
    }

    public static class BaitBlockCondition {
        private final IBlockState state;
        private final boolean isWildcard;

        public BaitBlockCondition(IBlockState state, boolean isWildcard) {
            this.state = state;
            this.isWildcard = isWildcard;
        }

        public IBlockState getState() {
            return this.state;
        }

        public boolean isWildcard() {
            return this.isWildcard;
        }
    }

    public static enum EnvironmentalCondition {
        CanSpawn("info.excompressum:baitCanSpawn"),
        NearbyBait("info.excompressum:baitNearbyBait"),
        WrongEnv("info.excompressum:baitWrongEnv"),
        NearbyAnimal("info.excompressum:baitNearbyAnimal"),
        NoWater("info.excompressum:baitNoWater");

        public final String langKey;

        private EnvironmentalCondition(String langKey) {
            this.langKey = langKey;
        }
    }
}

