/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.tile;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import javax.annotation.Nullable;
import net.blay09.mods.excompressum.config.ProcessingConfig;
import net.blay09.mods.excompressum.registry.compressor.CompressedRecipe;
import net.blay09.mods.excompressum.registry.compressor.CompressedRecipeRegistry;
import net.blay09.mods.excompressum.tile.TileEntityBase;
import net.blay09.mods.excompressum.utils.DefaultItemHandler;
import net.blay09.mods.excompressum.utils.EnergyStorageModifiable;
import net.blay09.mods.excompressum.utils.ItemHandlerAutomation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class TileAutoCompressor
extends TileEntityBase
implements ITickable {
    private final EnergyStorageModifiable energyStorage = new EnergyStorageModifiable(32000){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!simulate) {
                TileAutoCompressor.this.func_70296_d();
            }
            return super.receiveEnergy(maxReceive, simulate);
        }
    };
    private final Multiset<CompressedRecipe> inputItems = HashMultiset.create();
    private final DefaultItemHandler itemHandler = new DefaultItemHandler(this, 24){

        @Override
        public boolean isItemValid(int slot, ItemStack itemStack) {
            return slot >= 12 || CompressedRecipeRegistry.getRecipe(itemStack) != null;
        }
    };
    private final RangedWrapper inputSlots = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 0, 12);
    private final RangedWrapper outputSlots = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 12, 24);
    private final ItemHandlerAutomation itemHandlerAutomation = new ItemHandlerAutomation((IItemHandlerModifiable)this.itemHandler){

        @Override
        public boolean canInsertItem(int slot, ItemStack itemStack) {
            return slot < 12 && CompressedRecipeRegistry.getRecipe(itemStack) != null;
        }

        @Override
        public boolean canExtractItem(int slot, int amount) {
            return slot >= 12;
        }
    };
    private ItemStack currentStack;
    private float progress;

    public void func_73660_a() {
        int effectiveEnergy = this.getEffectiveEnergy();
        if (this.energyStorage.getEnergyStored() > effectiveEnergy) {
            if (this.currentStack == null) {
                this.inputItems.clear();
                for (int i = 0; i < this.inputSlots.getSlots(); ++i) {
                    CompressedRecipe compressedRecipe;
                    ItemStack slotStack = this.inputSlots.getStackInSlot(i);
                    if (slotStack == null || (compressedRecipe = CompressedRecipeRegistry.getRecipe(slotStack)) == null) continue;
                    this.inputItems.add((Object)compressedRecipe, slotStack.field_77994_a);
                }
                for (CompressedRecipe compressedRecipe : this.inputItems.elementSet()) {
                    ItemStack sourceStack = compressedRecipe.getSourceStack();
                    if (this.inputItems.count((Object)compressedRecipe) < sourceStack.field_77994_a) continue;
                    int space = 0;
                    for (int i = 0; i < this.outputSlots.getSlots(); ++i) {
                        ItemStack slotStack = this.outputSlots.getStackInSlot(i);
                        if (slotStack == null) {
                            space = 64;
                        } else if (this.isItemEqualWildcard(slotStack, compressedRecipe.getResultStack())) {
                            space += slotStack.func_77976_d() - slotStack.field_77994_a;
                        }
                        if (space >= compressedRecipe.getResultStack().field_77994_a) break;
                    }
                    if (space < compressedRecipe.getResultStack().field_77994_a) continue;
                    int count = sourceStack.field_77994_a;
                    for (int i = 0; i < this.inputSlots.getSlots(); ++i) {
                        ItemStack slotStack = this.inputSlots.getStackInSlot(i);
                        if (slotStack == null || !this.isItemEqualWildcard(slotStack, sourceStack)) continue;
                        if (slotStack.field_77994_a >= count) {
                            slotStack.field_77994_a -= count;
                            if (slotStack.field_77994_a == 0) {
                                this.inputSlots.setStackInSlot(i, null);
                            }
                            count = 0;
                            break;
                        }
                        count -= slotStack.field_77994_a;
                        this.inputSlots.setStackInSlot(i, null);
                    }
                    if (count <= 0) {
                        this.currentStack = sourceStack.func_77946_l();
                        this.progress = 0.0f;
                    }
                    break;
                }
            } else {
                this.energyStorage.extractEnergy(effectiveEnergy, false);
                this.progress = Math.min(1.0f, this.progress + this.getEffectiveSpeed());
                if (this.progress >= 1.0f) {
                    ItemStack resultStack;
                    CompressedRecipe compressedRecipe;
                    if (!this.field_145850_b.field_72995_K && (compressedRecipe = CompressedRecipeRegistry.getRecipe(this.currentStack)) != null && !this.addItemToOutput(resultStack = compressedRecipe.getResultStack().func_77946_l())) {
                        EntityItem entityItem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, resultStack);
                        double motion = 0.05;
                        entityItem.field_70159_w = this.field_145850_b.field_73012_v.nextGaussian() * motion;
                        entityItem.field_70181_x = 0.2;
                        entityItem.field_70179_y = this.field_145850_b.field_73012_v.nextGaussian() * motion;
                        this.field_145850_b.func_72838_d((Entity)entityItem);
                    }
                    this.currentStack = null;
                    this.progress = 0.0f;
                }
            }
        }
    }

    private boolean isItemEqualWildcard(ItemStack itemStack, ItemStack otherStack) {
        return ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)otherStack) && (itemStack.func_77969_a(otherStack) || itemStack.func_77973_b() == otherStack.func_77973_b() && (itemStack.func_77952_i() == Short.MAX_VALUE || otherStack.func_77952_i() == Short.MAX_VALUE));
    }

    private boolean addItemToOutput(ItemStack itemStack) {
        int firstEmptySlot = -1;
        for (int i = 0; i < this.outputSlots.getSlots(); ++i) {
            ItemStack slotStack = this.outputSlots.getStackInSlot(i);
            if (slotStack == null) {
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = i;
                continue;
            }
            if (slotStack.field_77994_a + itemStack.field_77994_a > slotStack.func_77976_d() || !this.isItemEqualWildcard(slotStack, itemStack)) continue;
            slotStack.field_77994_a += itemStack.field_77994_a;
            return true;
        }
        if (firstEmptySlot != -1) {
            this.outputSlots.setStackInSlot(firstEmptySlot, itemStack);
            return true;
        }
        return false;
    }

    public int getEffectiveEnergy() {
        return ProcessingConfig.autoCompressorEnergy;
    }

    public float getEffectiveSpeed() {
        return ProcessingConfig.autoCompressorSpeed;
    }

    @Override
    protected boolean hasUpdatePacket() {
        return false;
    }

    @Override
    protected void readFromNBTSynced(NBTTagCompound tagCompound, boolean isSync) {
        this.currentStack = ItemStack.func_77949_a((NBTTagCompound)tagCompound.func_74775_l("CurrentStack"));
        this.progress = tagCompound.func_74760_g("Progress");
        this.itemHandler.deserializeNBT(tagCompound.func_74775_l("ItemHandler"));
        if (tagCompound.func_74764_b("EnergyStorage")) {
            CapabilityEnergy.ENERGY.readNBT((Object)this.energyStorage, null, tagCompound.func_74781_a("EnergyStorage"));
        }
    }

    @Override
    protected void writeToNBTSynced(NBTTagCompound tagCompound, boolean isSync) {
        if (this.currentStack != null) {
            tagCompound.func_74782_a("CurrentStack", (NBTBase)this.currentStack.func_77955_b(new NBTTagCompound()));
        }
        tagCompound.func_74776_a("Progress", this.progress);
        tagCompound.func_74782_a("ItemHandler", (NBTBase)this.itemHandler.serializeNBT());
        tagCompound.func_74782_a("EnergyStorage", CapabilityEnergy.ENERGY.writeNBT((Object)this.energyStorage, null));
    }

    public boolean isProcessing() {
        return this.progress > 0.0f;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public float getEnergyPercentage() {
        return (float)this.energyStorage.getEnergyStored() / (float)this.energyStorage.getMaxEnergyStored();
    }

    @Nullable
    public ItemStack getCurrentStack() {
        return this.currentStack;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandlerAutomation;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.energyStorage);
        }
        return (T)super.getCapability(capability, facing);
    }

    public DefaultItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public EnergyStorageModifiable getEnergyStorage() {
        return this.energyStorage;
    }
}

