/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.registry.woodencrucible;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.api.RegistryType;
import net.blay09.mods.excompressum.registry.AbstractRegistry;
import net.blay09.mods.excompressum.registry.RegistryKey;
import net.blay09.mods.excompressum.registry.woodencrucible.WoodenCrucibleRegistryEntry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class WoodenCrucibleRegistry
extends AbstractRegistry {
    public static final WoodenCrucibleRegistry INSTANCE = new WoodenCrucibleRegistry();
    private final Map<RegistryKey, WoodenCrucibleRegistryEntry> entries = Maps.newHashMap();

    public WoodenCrucibleRegistry() {
        super("WoodenCrucible");
    }

    @Nullable
    public static WoodenCrucibleRegistryEntry getEntry(ItemStack itemStack) {
        RegistryKey key = new RegistryKey(itemStack);
        WoodenCrucibleRegistryEntry entry = WoodenCrucibleRegistry.INSTANCE.entries.get(key);
        if (entry != null) {
            return entry;
        }
        return WoodenCrucibleRegistry.INSTANCE.entries.get(key.withWildcard());
    }

    public Map<RegistryKey, WoodenCrucibleRegistryEntry> getEntries() {
        return this.entries;
    }

    private static void add(WoodenCrucibleRegistryEntry entry) {
        RegistryKey key = new RegistryKey(entry.getItemStack());
        if (WoodenCrucibleRegistry.INSTANCE.entries.containsKey(key)) {
            ExCompressum.logger.error("Duplicate entry for " + key + " in " + WoodenCrucibleRegistry.INSTANCE.registryName + ", overwriting...");
        }
        WoodenCrucibleRegistry.INSTANCE.entries.put(key, entry);
    }

    @Override
    protected void clear() {
        this.entries.clear();
    }

    @Override
    protected JsonObject create() {
        JsonObject root = new JsonObject();
        JsonObject defaults = new JsonObject();
        defaults.addProperty("__comment", "You can disable defaults by setting these to false. Do *NOT* try to add additional entries here. You can add additional entries in the custom section.");
        root.add("defaults", (JsonElement)defaults);
        JsonObject custom = new JsonObject();
        custom.addProperty("__comment", "You can define additional items to melt in the Wooden Crucible here. Use * as a wildcard for metadata. Use ore: prefix in name to query the Ore Dictionary. Metadata is ignored for Ore Dictionary entries.");
        JsonObject emptyEntry = new JsonObject();
        emptyEntry.addProperty("name", "");
        emptyEntry.addProperty("metadata", "*");
        emptyEntry.addProperty("fluid", "water");
        emptyEntry.addProperty("amount", (Number)0);
        JsonArray entries = new JsonArray();
        entries.add((JsonElement)emptyEntry);
        custom.add("entries", (JsonElement)entries);
        root.add("custom", (JsonElement)custom);
        JsonObject example = new JsonObject();
        example.addProperty("__comment", "This example would allow fish to be melted into 100mb of water.");
        example.addProperty("name", "minecraft:fish");
        example.addProperty("metadata", "0");
        example.addProperty("fluid", "water");
        example.addProperty("amount", (Number)100);
        root.add("example", (JsonElement)example);
        return root;
    }

    @Override
    protected void loadCustom(JsonObject entry) {
        String name = this.tryGetString(entry, "name", "");
        if (name.isEmpty()) {
            return;
        }
        ResourceLocation location = new ResourceLocation(name);
        String fluidName = this.tryGetString(entry, "fluid", "water");
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        if (fluid == null) {
            this.logUnknownFluid(fluidName, location);
            return;
        }
        int amount = this.tryGetInt(entry, "amount", 100);
        if (location.func_110624_b().equals("ore")) {
            if (!this.addOre(location.func_110623_a(), fluid, amount)) {
                this.logUnknownOre(location);
            }
        } else {
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)location);
            if (item == null) {
                this.logUnknownItem(location);
                return;
            }
            String metadata = this.tryGetString(entry, "metadata", "0");
            ItemStack itemStack = metadata.equals("*") ? new ItemStack(item, 1, Short.MAX_VALUE) : new ItemStack(item, 1, this.tryParseInt(metadata));
            WoodenCrucibleRegistry.add(new WoodenCrucibleRegistryEntry(itemStack, fluid, amount));
        }
    }

    @Override
    protected void registerDefaults(JsonObject defaults) {
        if (this.tryGetBoolean(defaults, "minecraft:apple", true)) {
            WoodenCrucibleRegistry.add(new WoodenCrucibleRegistryEntry(new ItemStack(Items.field_151034_e), FluidRegistry.WATER, 100));
        }
        if (this.tryGetBoolean(defaults, "ore:treeSapling", true)) {
            this.addOre("treeSapling", FluidRegistry.WATER, 100);
        }
        if (this.tryGetBoolean(defaults, "ore:treeLeaves", true)) {
            this.addOre("treeLeaves", FluidRegistry.WATER, 250);
        }
        if (this.tryGetBoolean(defaults, "minecraft:cactus", true)) {
            WoodenCrucibleRegistry.add(new WoodenCrucibleRegistryEntry(new ItemStack((Block)Blocks.field_150434_aF), FluidRegistry.WATER, 250));
        }
        if (this.tryGetBoolean(defaults, "minecraft:yellow_flower", true)) {
            WoodenCrucibleRegistry.add(new WoodenCrucibleRegistryEntry(new ItemStack((Block)Blocks.field_150327_N), FluidRegistry.WATER, 100));
        }
        if (this.tryGetBoolean(defaults, "minecraft:red_flower", true)) {
            WoodenCrucibleRegistry.add(new WoodenCrucibleRegistryEntry(new ItemStack((Block)Blocks.field_150328_O), FluidRegistry.WATER, 100));
        }
        if (this.tryGetBoolean(defaults, "ore:listAllfruit", true)) {
            this.addOre("listAllfruit", FluidRegistry.WATER, 50);
        }
    }

    @Override
    protected RegistryType getRegistryType() {
        return RegistryType.WoodenCrucible;
    }

    private boolean addOre(String oreName, Fluid fluid, int amount) {
        List list = OreDictionary.getOres((String)oreName, (boolean)false);
        for (ItemStack itemStack : list) {
            WoodenCrucibleRegistry.add(new WoodenCrucibleRegistryEntry(itemStack, fluid, amount));
        }
        return list.size() > 0;
    }
}

