/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.registry.heavysieve;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.api.RegistryType;
import net.blay09.mods.excompressum.block.BlockCompressed;
import net.blay09.mods.excompressum.block.ModBlocks;
import net.blay09.mods.excompressum.registry.AbstractRegistry;
import net.blay09.mods.excompressum.registry.ExNihiloProvider;
import net.blay09.mods.excompressum.registry.ExRegistro;
import net.blay09.mods.excompressum.registry.RegistryKey;
import net.blay09.mods.excompressum.registry.heavysieve.HeavySieveRegistryEntry;
import net.blay09.mods.excompressum.registry.heavysieve.HeavySieveReward;
import net.blay09.mods.excompressum.registry.sievemesh.SieveMeshRegistryEntry;
import net.blay09.mods.excompressum.utils.StupidUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;

public class HeavySieveRegistry
extends AbstractRegistry {
    public static final HeavySieveRegistry INSTANCE = new HeavySieveRegistry();
    private final Map<RegistryKey, HeavySieveRegistryEntry> entries = Maps.newHashMap();
    private static final int DEFAULT_LOSS = 2;
    private int defaultLoss;

    public HeavySieveRegistry() {
        super("HeavySieve");
    }

    @Nullable
    public static HeavySieveRegistryEntry getEntryForBlockState(IBlockState state, boolean withWildcard) {
        return HeavySieveRegistry.INSTANCE.entries.get(new RegistryKey(state, withWildcard));
    }

    public static boolean isSiftable(IBlockState state) {
        RegistryKey key = new RegistryKey(state, false);
        return HeavySieveRegistry.INSTANCE.entries.get(key) != null || HeavySieveRegistry.INSTANCE.entries.get(key.withWildcard()) != null;
    }

    public static boolean isSiftableWithMesh(IBlockState state, SieveMeshRegistryEntry sieveMesh) {
        if (ExRegistro.doMeshesSplitLootTables()) {
            RegistryKey key = new RegistryKey(state, false);
            HeavySieveRegistryEntry entry = HeavySieveRegistry.INSTANCE.entries.get(key);
            if (entry != null && !entry.getRewardsForMesh(sieveMesh).isEmpty()) {
                return true;
            }
            HeavySieveRegistryEntry wildcardEntry = HeavySieveRegistry.INSTANCE.entries.get(key.withWildcard());
            return wildcardEntry != null && !wildcardEntry.getRewardsForMesh(sieveMesh).isEmpty();
        }
        return HeavySieveRegistry.isSiftable(state);
    }

    public static boolean isSiftableWithMesh(ItemStack itemStack, SieveMeshRegistryEntry sieveMesh) {
        IBlockState state = StupidUtils.getStateFromItemStack(itemStack);
        return state != null && HeavySieveRegistry.isSiftableWithMesh(state, sieveMesh);
    }

    public static boolean isSiftable(ItemStack itemStack) {
        IBlockState state = StupidUtils.getStateFromItemStack(itemStack);
        return state != null && HeavySieveRegistry.isSiftable(state);
    }

    public void add(HeavySieveRegistryEntry entry) {
        RegistryKey key = new RegistryKey(entry.getInputState(), entry.isWildcard());
        HeavySieveRegistryEntry previousEntry = this.entries.get(key);
        if (previousEntry != null) {
            for (HeavySieveReward reward : entry.getRewards()) {
                previousEntry.addReward(reward);
            }
        } else {
            this.entries.put(key, entry);
        }
    }

    public Map<RegistryKey, HeavySieveRegistryEntry> getEntries() {
        return this.entries;
    }

    public static Collection<ItemStack> rollSieveRewards(IBlockState state, SieveMeshRegistryEntry sieveMesh, float luck, Random rand) {
        HeavySieveRegistryEntry wildcardEntry;
        ArrayList list = Lists.newArrayList();
        RegistryKey key = new RegistryKey(state, false);
        HeavySieveRegistryEntry entry = HeavySieveRegistry.INSTANCE.entries.get(key);
        if (entry != null) {
            HeavySieveRegistry.rollSieveRewardsToList(entry, list, sieveMesh, luck, rand);
        }
        if ((wildcardEntry = HeavySieveRegistry.INSTANCE.entries.get(key.withWildcard())) != null) {
            HeavySieveRegistry.rollSieveRewardsToList(wildcardEntry, list, sieveMesh, luck, rand);
        }
        return list;
    }

    public static Collection<ItemStack> rollSieveRewards(ItemStack itemStack, SieveMeshRegistryEntry sieveMesh, float luck, Random rand) {
        IBlockState state = StupidUtils.getStateFromItemStack(itemStack);
        if (state != null) {
            return HeavySieveRegistry.rollSieveRewards(state, sieveMesh, luck, rand);
        }
        return Collections.emptyList();
    }

    private static void rollSieveRewardsToList(HeavySieveRegistryEntry entry, List<ItemStack> list, SieveMeshRegistryEntry sieveMesh, float luck, Random rand) {
        for (HeavySieveReward reward : entry.getRewardsForMesh(sieveMesh)) {
            int tries = rand.nextInt((int)luck + 1) + 1;
            for (int i = 0; i < tries; ++i) {
                if (!(rand.nextFloat() < reward.getBaseChance())) continue;
                list.add(reward.getItemStack().func_77946_l());
            }
        }
    }

    @Override
    protected void clear() {
        this.entries.clear();
        this.defaultLoss = 2;
    }

    @Override
    protected JsonObject create() {
        JsonObject root = new JsonObject();
        JsonObject options = new JsonObject();
        options.addProperty("__comment", "These options will affect the auto-generation of sieve rewards for compressed blocks. You can turn the auto-generation off individually in the defaults section.");
        root.add("options", (JsonElement)options);
        JsonObject defaults = new JsonObject();
        defaults.addProperty("__comment", "You can disable defaults by setting these to false. Do *NOT* try to add additional entries here. You can add additional entries in the custom section.");
        root.add("defaults", (JsonElement)defaults);
        JsonObject custom = new JsonObject();
        custom.addProperty("__comment", "You can define additional blocks to sift in the Heavy Sieve here. Use * as a wildcard for metadata. Ure ore: prefix in name to query the Ore Dictionary. Mesh Level is only used for Adscensio.");
        JsonArray entries = new JsonArray();
        JsonObject emptyEntry = new JsonObject();
        emptyEntry.addProperty("name", "");
        emptyEntry.addProperty("metadata", "*");
        emptyEntry.addProperty("type", "list");
        JsonArray rewards = new JsonArray();
        JsonObject reward = new JsonObject();
        reward.addProperty("name", "");
        reward.addProperty("metadata", (Number)0);
        reward.addProperty("count", (Number)1);
        reward.addProperty("chance", (Number)Float.valueOf(1.0f));
        reward.addProperty("luck", (Number)Float.valueOf(0.0f));
        rewards.add((JsonElement)reward);
        emptyEntry.add("rewards", (JsonElement)rewards);
        entries.add((JsonElement)emptyEntry);
        emptyEntry = new JsonObject();
        emptyEntry.addProperty("name", "");
        emptyEntry.addProperty("metadata", "*");
        emptyEntry.addProperty("type", "generate");
        emptyEntry.addProperty("source", "");
        emptyEntry.addProperty("sourceMetadata", "*");
        emptyEntry.addProperty("sourceCount", (Number)9);
        entries.add((JsonElement)emptyEntry);
        custom.add("entries", (JsonElement)entries);
        JsonObject example = new JsonObject();
        example.addProperty("__comment", "This example would allow Double Compressed Gravel to be sifted in a Heavy Sieve into 64x the rewards of normal gravel.");
        example.addProperty("name", "ExUtils2:CompressedGravel");
        example.addProperty("metadata", "1");
        example.addProperty("type", "generate");
        example.addProperty("source", "minecraft:gravel");
        example.addProperty("sourceMetadata", "*");
        example.addProperty("sourceCount", (Number)64);
        custom.add("example_generate", (JsonElement)example);
        example = new JsonObject();
        example.addProperty("__comment", "This example would allow clay to be sifted in a Heavy Sieve into 6 diamonds.");
        example.addProperty("name", "ExUtils2:CompressedGravel");
        example.addProperty("metadata", "1");
        example.addProperty("type", "list");
        rewards = new JsonArray();
        reward = new JsonObject();
        reward.addProperty("name", "minecraft:diamond");
        reward.addProperty("metadata", (Number)0);
        reward.addProperty("count", (Number)6);
        reward.addProperty("chance", (Number)Float.valueOf(1.0f));
        reward.addProperty("luck", (Number)Float.valueOf(0.0f));
        rewards.add((JsonElement)reward);
        example.add("rewards", (JsonElement)rewards);
        custom.add("example_list", (JsonElement)example);
        root.add("custom", (JsonElement)custom);
        return root;
    }

    @Override
    protected boolean hasOptions() {
        return true;
    }

    @Override
    protected void loadOptions(JsonObject entry) {
        this.defaultLoss = this.tryGetInt(entry, "loss for default generated rewards (out of 9)", 2);
        if (this.defaultLoss < 0 || this.defaultLoss > 8) {
            this.logError("Default loss option in %s is out of range, resetting to %d...", this.registryName, 2);
            this.defaultLoss = 2;
        }
    }

    @Override
    protected void loadCustom(JsonObject entry) {
        String type;
        String name = this.tryGetString(entry, "name", "");
        if (name.isEmpty()) {
            return;
        }
        ResourceLocation location = new ResourceLocation(name);
        String metadata = this.tryGetString(entry, "metadata", "0");
        int metadataVal = metadata.equals("*") ? Short.MAX_VALUE : this.tryParseInt(metadata);
        switch (type = this.tryGetString(entry, "type", "")) {
            case "generate": {
                String sourceName = this.tryGetString(entry, "sourceName", "");
                if (sourceName.isEmpty()) {
                    return;
                }
                ResourceLocation sourceLocation = new ResourceLocation(sourceName);
                Item sourceItem = (Item)Item.field_150901_e.func_82594_a((Object)sourceLocation);
                if (sourceItem == null) {
                    this.logUnknownItem(sourceLocation);
                    return;
                }
                String sourceMetadata = this.tryGetString(entry, "sourceMetadata", "0");
                int sourceMetadataVal = sourceMetadata.equals("*") ? Short.MAX_VALUE : this.tryParseInt(sourceMetadata);
                ItemStack sourceStack = new ItemStack(sourceItem, 1, sourceMetadataVal);
                int sourceCount = this.tryGetInt(entry, "sourceCount", 9);
                if (location.func_110624_b().equals("ore")) {
                    if (this.addOreGenerated(location.func_110623_a(), sourceStack, sourceCount)) break;
                    this.logUnknownOre(location);
                    break;
                }
                Item item = (Item)Item.field_150901_e.func_82594_a((Object)location);
                if (item == null) {
                    this.logUnknownItem(location);
                    return;
                }
                this.addGeneratedEntry(new ItemStack(item, 1, metadataVal), sourceStack, sourceCount);
                break;
            }
            case "list": {
                JsonArray rewards = this.tryGetArray(entry, "rewards");
                ArrayList rewardList = Lists.newArrayListWithCapacity((int)rewards.size());
                for (int i = 0; i < rewards.size(); ++i) {
                    float chance;
                    int rewardMetadata;
                    int count;
                    Item item;
                    JsonObject reward;
                    JsonElement element = rewards.get(i);
                    if (element.isJsonObject()) {
                        reward = element.getAsJsonObject();
                        String rewardName = this.tryGetString(reward, "name", "");
                        if (rewardName.isEmpty()) continue;
                        ResourceLocation rewardLocation = new ResourceLocation(rewardName);
                        item = (Item)Item.field_150901_e.func_82594_a((Object)rewardLocation);
                        if (item == null) {
                            this.logUnknownItem(rewardLocation);
                            continue;
                        }
                        count = this.tryGetInt(reward, "count", 1);
                        rewardMetadata = this.tryGetInt(reward, "metadata", 0);
                        chance = this.tryGetFloat(reward, "chance", 1.0f);
                        if (chance > 1.0f) {
                            this.logError("Reward chance is out of range for %s in %s, capping at 1.0...", rewardLocation, this.registryName);
                            chance = 1.0f;
                        }
                    } else {
                        this.logError("Failed to preInit %s registry; rewards must be an array of json objects", this.registryName);
                        return;
                    }
                    int meshLevel = this.tryGetInt(reward, "meshLevel", 1);
                    rewardList.add(new HeavySieveReward(new ItemStack(item, count, rewardMetadata), chance, meshLevel));
                    if (location.func_110624_b().equals("ore")) {
                        if (this.addOre(location.func_110623_a(), rewardList)) continue;
                        this.logUnknownOre(location);
                        continue;
                    }
                    Item item2 = (Item)Item.field_150901_e.func_82594_a((Object)location);
                    if (item2 == null) {
                        this.logUnknownItem(location);
                        return;
                    }
                    ItemStack itemStack = new ItemStack(item2, 1, metadataVal);
                    IBlockState state = StupidUtils.getStateFromItemStack(itemStack);
                    if (state != null) {
                        HeavySieveRegistryEntry newEntry = new HeavySieveRegistryEntry(state, itemStack.func_77952_i() == Short.MAX_VALUE);
                        for (HeavySieveReward reward2 : rewardList) {
                            newEntry.addReward(reward2);
                        }
                        this.add(newEntry);
                        continue;
                    }
                    this.logError("Entry %s could not be registered for %s; it's not a block", location, this.registryName);
                }
                break;
            }
            default: {
                this.logError("Unknown type %s for %s in %s, skipping...", type, location, this.registryName);
            }
        }
    }

    @Override
    protected void registerDefaults(JsonObject defaults) {
        ItemStack enderGravelBlock;
        ItemStack netherGravelBlock;
        ItemStack itemStack;
        ItemStack dustBlock;
        ItemStack itemStack2;
        ItemStack GRAVEL = new ItemStack(Blocks.field_150351_n);
        ItemStack SAND = new ItemStack((Block)Blocks.field_150354_m);
        ItemStack DIRT = new ItemStack(Blocks.field_150346_d);
        ItemStack SOUL_SAND = new ItemStack(Blocks.field_150425_aM);
        int COMPRESSION_SIZE = 9;
        if (this.tryGetBoolean(defaults, "excompressum:compressed_gravel", true)) {
            itemStack2 = new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.GRAVEL.ordinal());
            this.addGeneratedEntry(itemStack2, GRAVEL, 9 - this.defaultLoss);
        }
        if (this.tryGetBoolean(defaults, "excompressum:compressed_sand", true)) {
            itemStack2 = new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.SAND.ordinal());
            this.addGeneratedEntry(itemStack2, SAND, 9 - this.defaultLoss);
        }
        if (this.tryGetBoolean(defaults, "excompressum:compressed_dirt", true)) {
            itemStack2 = new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.DIRT.ordinal());
            this.addGeneratedEntry(itemStack2, DIRT, 9 - this.defaultLoss);
        }
        if (this.tryGetBoolean(defaults, "excompressum:compressed_soul_sand", true)) {
            itemStack2 = new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.SOUL_SAND.ordinal());
            this.addGeneratedEntry(itemStack2, SOUL_SAND, 9 - this.defaultLoss);
        }
        if (this.tryGetBoolean(defaults, "excompressum:compressed_dust", true) && (dustBlock = ExRegistro.getNihiloItem(ExNihiloProvider.NihiloItems.DUST)) != null) {
            itemStack = new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.DUST.ordinal());
            this.addGeneratedEntry(itemStack, dustBlock, 9 - this.defaultLoss);
        }
        if (this.tryGetBoolean(defaults, "excompressum:compressed_nether_gravel", true) && (netherGravelBlock = ExRegistro.getNihiloItem(ExNihiloProvider.NihiloItems.NETHER_GRAVEL)) != null) {
            itemStack = new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.NETHER_GRAVEL.ordinal());
            this.addGeneratedEntry(itemStack, netherGravelBlock, 9 - this.defaultLoss);
        }
        if (this.tryGetBoolean(defaults, "excompressum:compressed_ender_gravel", true) && (enderGravelBlock = ExRegistro.getNihiloItem(ExNihiloProvider.NihiloItems.ENDER_GRAVEL)) != null) {
            itemStack = new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.ENDER_GRAVEL.ordinal());
            this.addGeneratedEntry(itemStack, enderGravelBlock, 9 - this.defaultLoss);
        }
        if (Loader.isModLoaded((String)"extrautils2") || Loader.isModLoaded((String)"ExtraUtils2")) {
            ItemStack itemStack3;
            Item exUtilsBlock;
            ResourceLocation location;
            if (this.tryGetBoolean(defaults, "ExtraUtils2:CompressedGravel", true)) {
                location = new ResourceLocation("extrautils2", "compressedgravel");
                if (!Block.field_149771_c.func_148741_d((Object)location)) {
                    location = new ResourceLocation("ExtraUtils2", "CompressedGravel");
                }
                if ((exUtilsBlock = (Item)Item.field_150901_e.func_82594_a((Object)location)) != null) {
                    itemStack3 = new ItemStack(exUtilsBlock, 1, 0);
                    this.addGeneratedEntry(itemStack3, GRAVEL, 9 - this.defaultLoss);
                }
            }
            if (this.tryGetBoolean(defaults, "ExtraUtils2:CompressedSand", true)) {
                location = new ResourceLocation("extrautils2", "compressedsand");
                if (!Block.field_149771_c.func_148741_d((Object)location)) {
                    location = new ResourceLocation("ExtraUtils2", "CompressedSand");
                }
                if ((exUtilsBlock = (Item)Item.field_150901_e.func_82594_a((Object)location)) != null) {
                    itemStack3 = new ItemStack(exUtilsBlock, 1, 0);
                    this.addGeneratedEntry(itemStack3, SAND, 9 - this.defaultLoss);
                }
            }
            if (this.tryGetBoolean(defaults, "ExtraUtils2:CompressedDirt", true)) {
                location = new ResourceLocation("extrautils2", "compresseddirt");
                if (!Block.field_149771_c.func_148741_d((Object)location)) {
                    location = new ResourceLocation("ExtraUtils2", "CompressedDirt");
                }
                if ((exUtilsBlock = (Item)Item.field_150901_e.func_82594_a((Object)location)) != null) {
                    itemStack3 = new ItemStack(exUtilsBlock, 1, 0);
                    this.addGeneratedEntry(itemStack3, DIRT, 9 - this.defaultLoss);
                }
            }
        }
    }

    @Override
    protected RegistryType getRegistryType() {
        return RegistryType.HeavySieve;
    }

    private boolean addOre(String oreName, List<HeavySieveReward> rewards) {
        List list = OreDictionary.getOres((String)oreName, (boolean)false);
        for (ItemStack itemStack : list) {
            IBlockState state = StupidUtils.getStateFromItemStack(itemStack);
            if (state != null) {
                HeavySieveRegistryEntry entry = new HeavySieveRegistryEntry(state, itemStack.func_77952_i() == Short.MAX_VALUE);
                for (HeavySieveReward reward : rewards) {
                    entry.addReward(reward);
                }
                this.add(entry);
                continue;
            }
            ExCompressum.logger.warn("Ore dictionary entry {} in {} could not be registered for {}; it's not a block", new Object[]{itemStack.func_77973_b().getRegistryName(), oreName, this.registryName});
        }
        return list.size() > 0;
    }

    private boolean addOreGenerated(String oreName, ItemStack sourceStack, int sourceCount) {
        List list = OreDictionary.getOres((String)oreName, (boolean)false);
        for (ItemStack itemStack : list) {
            this.addGeneratedEntry(itemStack, sourceStack, sourceCount);
        }
        return list.size() > 0;
    }

    private void addGeneratedEntry(ItemStack itemStack, ItemStack sourceStack, int count) {
        IBlockState state = StupidUtils.getStateFromItemStack(itemStack);
        if (state == null) {
            this.logError("Entry %s could not be generated from %s for %s; it's not a block", itemStack.func_77973_b().getRegistryName(), sourceStack.func_77973_b().getRegistryName(), this.registryName);
            return;
        }
        HeavySieveRegistryEntry entry = new HeavySieveRegistryEntry(state, itemStack.func_77952_i() == Short.MAX_VALUE);
        Collection<HeavySieveReward> rewards = ExRegistro.generateHeavyRewards(sourceStack, count);
        if (rewards.isEmpty()) {
            this.logWarning("Entry %s could not be generated in %s because %s is not an Ex Nihilo siftable", itemStack.func_77973_b().getRegistryName(), this.registryName, sourceStack.func_77973_b().getRegistryName());
            return;
        }
        entry.addRewards(rewards);
        this.add(entry);
    }
}

